/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.artifacts;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.items.CatalystItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.AttributeEffectBuilder;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.WeaponUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArtifactStatCalculator {
    private final EnumMap<StatType, Float> finalStats = new EnumMap(StatType.class);
    private Map<String, Element> elements = new HashMap<String, Element>();

    public ArtifactStatCalculator() {
        for (StatType stat : StatType.values()) {
            this.finalStats.put(stat, Float.valueOf(0.0f));
        }
    }

    public void updateElements(List<ItemStack> artifacts) {
        for (ItemStack artifact : artifacts) {
            if (!(artifact.m_41720_() instanceof IElementItem)) continue;
            Element element = ElementsUtils.getElement(artifact);
            this.elements.put(element.name().toLowerCase(), element);
        }
    }

    public void updateStats(List<ItemStack> artifacts) {
        EnumMap<StatType, Float> tempStats = new EnumMap<StatType, Float>(StatType.class);
        for (ItemStack artifact : artifacts) {
            Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
            for (Map.Entry<StatType, Float> entry : artifactStats.entrySet()) {
                StatType stat = entry.getKey();
                float value = entry.getValue().floatValue();
                tempStats.merge(stat, Float.valueOf(value), Float::sum);
            }
        }
        this.finalStats.putAll(tempStats);
    }

    public float getStatValue(StatType statType) {
        return this.finalStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(List<ItemStack> artifacts, StatType statType) {
        EnumMap<StatType, Float> tempStats = new EnumMap<StatType, Float>(StatType.class);
        for (ItemStack artifact : artifacts) {
            Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
            for (Map.Entry<StatType, Float> entry : artifactStats.entrySet()) {
                StatType stat = entry.getKey();
                float value = entry.getValue().floatValue();
                tempStats.merge(stat, Float.valueOf(value), Float::sum);
            }
        }
        return tempStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(ItemStack weapon, List<ItemStack> artifacts, StatType stat) {
        CompoundTag stats;
        CompoundTag tag;
        float total = 0.0f;
        if (weapon != null && weapon.m_41782_() && (tag = weapon.m_41783_()) != null && tag.m_128425_("etheria$stats", 10) && (stats = tag.m_128469_("etheria$stats")).m_128441_(stat.name())) {
            total += stats.m_128457_(stat.name());
        }
        return total += ArtifactStatCalculator.getStatValue(artifacts, stat);
    }

    public static float getStatValue(ItemStack artifact, StatType statType) {
        Map<StatType, Float> artifactStats = ArtifactStatsManager.getAllStats(artifact);
        return artifactStats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static float getStatValue(Map<StatType, Float> stats, StatType statType) {
        return stats.getOrDefault((Object)statType, Float.valueOf(0.0f)).floatValue();
    }

    public static DamageContext createContext(LivingEntity attacker, float spellBaseDamage, Element spellElement) {
        ItemStack offHand;
        WeaponItem weapon;
        MutableStats stats = new MutableStats();
        HashMap<Element, Float> elementalBonuses = new HashMap<Element, Float>();
        for (Element e : Element.values()) {
            elementalBonuses.put(e, Float.valueOf(0.0f));
        }
        float totalRawDamage = 0.0f;
        ItemStack mainHand = attacker.m_21205_();
        Object object = mainHand.m_41720_();
        if (object instanceof CatalystItem) {
            CatalystItem weapon2 = (CatalystItem)object;
            ArtifactStatCalculator.collectAttributes(mainHand, weapon2.getAdditionalAttribute(), stats, elementalBonuses);
        } else {
            object = mainHand.m_41720_();
            if (object instanceof WeaponItem) {
                weapon = (WeaponItem)((Object)object);
                totalRawDamage += weapon.calculateDamage(mainHand);
                ArtifactStatCalculator.collectAttributes(mainHand, weapon.getAdditionalAttribute(), stats, elementalBonuses);
            }
        }
        if (totalRawDamage == 0.0f) {
            totalRawDamage = 1.0f;
        }
        if ((object = (offHand = attacker.m_21206_()).m_41720_()) instanceof WeaponItem) {
            weapon = (WeaponItem)((Object)object);
            ArtifactStatCalculator.collectAttributes(offHand, weapon.getAdditionalAttribute(), stats, elementalBonuses);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                Item item;
                if (stack == mainHand || stack == offHand || stack.m_41619_() || !((item = stack.m_41720_()) instanceof WeaponItem)) continue;
                WeaponItem weapon3 = (WeaponItem)item;
                ArtifactStatCalculator.collectAttributes(stack, weapon3.getAdditionalAttribute(), stats, elementalBonuses);
            }
            CapabilityRegistry.getCapability(player).ifPresent(cap -> {
                ArrayList<ItemStack> artifacts = new ArrayList<ItemStack>(cap.getArtifacts().values());
                stats.damagePercent += ArtifactStatCalculator.getStatValue(artifacts, StatType.DAMAGE);
                stats.critRate += ArtifactStatCalculator.getStatValue(artifacts, StatType.CRIT_CHANCE);
                stats.critDmg += ArtifactStatCalculator.getStatValue(artifacts, StatType.CRIT_DAMAGE);
                stats.elementaryAmplification += ArtifactStatCalculator.getStatValue(artifacts, StatType.ELEMENTAL_AMPLIFICATION);
                elementalBonuses.merge(Element.AERO, Float.valueOf(ArtifactStatCalculator.getStatValue(artifacts, StatType.AERO_DAMAGE)), Float::sum);
                elementalBonuses.merge(Element.PYRO, Float.valueOf(ArtifactStatCalculator.getStatValue(artifacts, StatType.PYRO_DAMAGE)), Float::sum);
                elementalBonuses.merge(Element.CRYO, Float.valueOf(ArtifactStatCalculator.getStatValue(artifacts, StatType.CRYO_DAMAGE)), Float::sum);
            });
        }
        return new DamageContext(attacker, spellElement, spellBaseDamage, totalRawDamage, stats.damagePercent, stats.elementaryAmplification, stats.critRate, stats.critDmg, elementalBonuses);
    }

    private static void collectAttributes(ItemStack stack, AttributeEffectBuilder builder, MutableStats stats, Map<Element, Float> eMap) {
        int stars = WeaponUtils.getStars(stack);
        Map<StatType, double[]> map = builder.getAttributes();
        for (Map.Entry<StatType, double[]> entry : map.entrySet()) {
            double[] vals = entry.getValue();
            double val = vals != null && vals.length > 0 ? vals[Math.min(stars, vals.length - 1)] : 0.0;
            float fVal = (float)val;
            switch (entry.getKey()) {
                case DAMAGE: {
                    stats.damagePercent += fVal;
                    break;
                }
                case CRIT_CHANCE: {
                    stats.critRate += fVal;
                    break;
                }
                case CRIT_DAMAGE: {
                    stats.critDmg += fVal;
                    break;
                }
                case ELEMENTAL_AMPLIFICATION: {
                    stats.elementaryAmplification += fVal;
                    break;
                }
                case AERO_DAMAGE: {
                    eMap.merge(Element.AERO, Float.valueOf(fVal), Float::sum);
                    break;
                }
                case PYRO_DAMAGE: {
                    eMap.merge(Element.PYRO, Float.valueOf(fVal), Float::sum);
                    break;
                }
                case CRYO_DAMAGE: {
                    eMap.merge(Element.CRYO, Float.valueOf(fVal), Float::sum);
                    break;
                }
            }
        }
    }

    public EnumMap<StatType, Float> getFinalStats() {
        return this.finalStats;
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public void setElements(Map<String, Element> elements) {
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactStatCalculator)) {
            return false;
        }
        ArtifactStatCalculator other = (ArtifactStatCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumMap<StatType, Float> this$finalStats = this.getFinalStats();
        EnumMap<StatType, Float> other$finalStats = other.getFinalStats();
        if (this$finalStats == null ? other$finalStats != null : !((Object)this$finalStats).equals(other$finalStats)) {
            return false;
        }
        Map<String, Element> this$elements = this.getElements();
        Map<String, Element> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArtifactStatCalculator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumMap<StatType, Float> $finalStats = this.getFinalStats();
        result = result * 59 + ($finalStats == null ? 43 : ((Object)$finalStats).hashCode());
        Map<String, Element> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "ArtifactStatCalculator(finalStats=" + String.valueOf(this.getFinalStats()) + ", elements=" + String.valueOf(this.getElements()) + ")";
    }

    private static class MutableStats {
        float damagePercent = 0.0f;
        float critRate = 5.0f;
        float critDmg = 50.0f;
        float elementaryAmplification = 0.0f;

        private MutableStats() {
        }
    }
}

