/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.client.gui.SpellsHud;
import it.mralxart.etheria.client.particles.BlockParticleProvider;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.client.particles.GlowingParticleProvider;
import it.mralxart.etheria.client.renderer.bosses.GaiaarRenderer;
import it.mralxart.etheria.client.renderer.entities.NullableRender;
import it.mralxart.etheria.client.renderer.tiles.BeamEmitterRenderer;
import it.mralxart.etheria.client.renderer.tiles.BeamRefractorRenderer;
import it.mralxart.etheria.client.renderer.tiles.CryoPedestalRenderer;
import it.mralxart.etheria.client.renderer.tiles.CryoSealRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherAltarRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherCollectorRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherDistributorRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherLoomRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherPedestalRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherPrismRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherReceiverRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherSenderRenderer;
import it.mralxart.etheria.client.renderer.tiles.EtherSourceRenderer;
import it.mralxart.etheria.client.renderer.tiles.IceSourceRenderer;
import it.mralxart.etheria.client.renderer.tiles.PyroPedestalRenderer;
import it.mralxart.etheria.client.renderer.tiles.RunicPedestalRenderer;
import it.mralxart.etheria.client.renderer.tiles.TrialRenderer;
import it.mralxart.etheria.entities.EnigmaCrystal;
import it.mralxart.etheria.entities.FlyingBlockEntity;
import it.mralxart.etheria.epicora.animations.util.AnimationsLoader;
import it.mralxart.etheria.epicora.geometry.util.GeometryLoader;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.spells.entities.BarrageSpearEntity;
import it.mralxart.etheria.magic.spells.entities.Explosion;
import it.mralxart.etheria.magic.spells.entities.FrostShackles;
import it.mralxart.etheria.magic.spells.entities.IcySpearEntity;
import it.mralxart.etheria.magic.spells.entities.IcySwordEntity;
import it.mralxart.etheria.magic.spells.entities.ScreenShakeEntity;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.WeaponRarity;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.registry.ParticleRegistry;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="etheria", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EtheriaClient {
    private static ShaderInstance glowingShader;
    private static ShaderInstance glowParticle;
    public static ShaderInstance BLACK_HOLE_SHADER;
    public static final RenderStateShard.TransparencyStateShard TRANSPARENCY;
    public static final RenderType GLOW_EFFECT;

    public static void init() {
        GeometryLoader.init();
        AnimationsLoader.init();
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)EntityRegistry.AEROLITH.get(), GaiaarRenderer::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.FROST_SHACKLES.get(), FrostShackles.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.ICY_SPEAR.get(), IcySpearEntity.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.EXPLOSION.get(), Explosion.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_NIHILIS.get(), EnigmaCrystal.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.BARRAGE_SPEAR.get(), BarrageSpearEntity.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.ICY_SWORD.get(), IcySwordEntity.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.FLYING_BLOCK.get(), FlyingBlockEntity.Render::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.ELEMENTAL_BARRAGE_SPEAR.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.SHOCKWAVE.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.METEORITE.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.SPELL_WHIRL.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.AIRFLOW.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.FROZEN_STORM.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.ELEMENT_RAIN.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.ELEMENT_RAIN_FALL.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.PHOENIX_RISE.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.SPELL.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.SCREEN_SHAKE.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.FROZEN_ORBIT.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.FIRE_WHIRL.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.BLAZING_RING.get(), NullableRender::new);
        e.registerEntityRenderer((EntityType)EntityRegistry.CAMERA.get(), NullableRender::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_PEDESTAL.get(), EtherPedestalRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.CRYO_PEDESTAL.get(), CryoPedestalRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.PYRO_PEDESTAL.get(), PyroPedestalRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.TRIAL.get(), TrialRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.CRYO_SEAL_PEDESTAL.get(), CryoSealRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.PYRO_SEAL_PEDESTAL.get(), CryoSealRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.SENDER.get(), EtherSenderRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.RECEIVER.get(), EtherReceiverRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.BEAM_EMITTER.get(), BeamEmitterRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.BEAM_REFRACTOR.get(), BeamRefractorRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ICE_SOURCE.get(), IceSourceRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_ALTAR.get(), EtherAltarRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_SOURCE.get(), EtherSourceRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_COLLECTOR.get(), EtherCollectorRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_PRISM.get(), EtherPrismRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.RUNIC_PEDESTAL.get(), RunicPedestalRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_DISTRIBUTOR.get(), EtherDistributorRenderer::new);
        e.registerBlockEntityRenderer((BlockEntityType)TileRegistry.ETHER_LOOM.get(), EtherLoomRenderer::new);
    }

    @SubscribeEvent
    public static void particleRegistry(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.GLOW_PARTICLE.get(), GlowingParticleProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.BLOCK_PARTICLE.get(), BlockParticleProvider::new);
    }

    @SubscribeEvent
    public static void onOverlayRegistry(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("spells_hud", (ForgeGui2, guiGraphics, partialTick, screenWidth, screenHeight) -> SpellsHud.renderHud(guiGraphics, partialTick));
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("etheria:glow_effect"), DefaultVertexFormat.f_85815_), shader -> {
            glowingShader = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("etheria:glow_particle"), DefaultVertexFormat.f_85819_), shader -> {
            glowParticle = shader;
        });
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)ItemRegistry.SPELL_SCROLL.get()), (ResourceLocation)new ResourceLocation("etheria", "spell_id"), (stack, world, entity, seed) -> {
            if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("spell_id")) {
                return (float)SpellsUtils.getIntIdSpell(stack.m_41783_().m_128461_("spell_id")) * 0.1f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ItemRegistry.ELEMENTAL_EMBLEM.get()), (ResourceLocation)new ResourceLocation("etheria", "element"), (stack, world, entity, seed) -> {
            if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
                String element = stack.m_41783_().m_128461_("etheria$element");
                return switch (element.toUpperCase()) {
                    case "NONE" -> 0.1f;
                    case "PYRO" -> 0.2f;
                    case "AERO" -> 0.3f;
                    case "ETHER" -> 0.4f;
                    case "CRYO" -> 0.5f;
                    default -> 0.1f;
                };
            }
            return 0.0f;
        });
    }

    public static ShaderInstance getGlowingShader() {
        return glowingShader;
    }

    public static ShaderInstance getGlowParticle() {
        return glowParticle;
    }

    public static ShaderInstance getBLACK_HOLE_SHADER() {
        return BLACK_HOLE_SHADER;
    }

    static {
        TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        GLOW_EFFECT = RenderType.m_173215_((String)"etheria:glow_effect", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110685_(TRANSPARENCY).m_173292_(new RenderStateShard.ShaderStateShard(EtheriaClient::getGlowingShader)).m_110691_(false));
    }

    @Mod.EventBusSubscriber(modid="etheria", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeEvents {
        private static float fogTick = 0.0f;
        private static boolean blackHole = false;
        public static float lastShakePitch = 0.0f;
        public static float lastShakeYaw = 0.0f;
        public static float lastShakeRoll = 0.0f;

        @SubscribeEvent
        public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = event.getItemStack();
            Item item = stack.m_41720_();
            if (item instanceof WeaponItem) {
                WeaponItem weaponItem = (WeaponItem)item;
                WeaponRarity rarity = weaponItem.getWeaponRarity();
                if (rarity.equals((Object)WeaponRarity.STARRY)) {
                    float progress1 = (float)(0.5 * (1.0 + Math.sin(Blaze3D.m_83640_() * 20.0 % 40.0 / 40.0 * Math.PI * 2.0)));
                    float progress2 = (float)(0.5 * (1.0 + Math.sin(Blaze3D.m_83640_() * 20.0 % 40.0 / 40.0 * Math.PI * 2.0 + Math.PI)));
                    int startColor = rarity.getStartColor();
                    int endColor = rarity.getEndColor();
                    int animatedColor = ForgeEvents.lerpColor(startColor, endColor, progress1);
                    event.setBorderStart(animatedColor);
                    event.setBorderEnd(ForgeEvents.lerpColor(startColor, endColor, progress2));
                } else {
                    event.setBorderStart(rarity.getStartColor());
                    event.setBorderEnd(rarity.getEndColor());
                    Item progress2 = stack.m_41720_();
                    if (progress2 instanceof IElementItem) {
                        IElementItem item2 = (IElementItem)progress2;
                        int startColor = ElementsUtils.getColorByElement(item2.getElement(stack)).getRGB();
                        int endColor = ElementsUtils.getEndColorByElement(item2.getElement(stack)).getRGB();
                        event.setBorderStart(startColor);
                        event.setBorderEnd(rarity.getEndColor());
                    }
                }
            }
        }

        private static int lerpColor(int color1, int color2, float t) {
            int a1 = color1 >> 24 & 0xFF;
            int r1 = color1 >> 16 & 0xFF;
            int g1 = color1 >> 8 & 0xFF;
            int b1 = color1 & 0xFF;
            int a2 = color2 >> 24 & 0xFF;
            int r2 = color2 >> 16 & 0xFF;
            int g2 = color2 >> 8 & 0xFF;
            int b2 = color2 & 0xFF;
            int a = (int)((float)a1 + (float)(a2 - a1) * t);
            int r = (int)((float)r1 + (float)(r2 - r1) * t);
            int g = (int)((float)g1 + (float)(g2 - g1) * t);
            int b = (int)((float)b1 + (float)(b2 - b1) * t);
            return a << 24 | r << 16 | g << 8 | b;
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END || Minecraft.m_91087_().m_91104_()) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (level == null || player == null || player.f_19797_ % 2 != 0) {
                return;
            }
            List<Aerolith> list = ForgeEvents.isAerolithNearby((Player)player);
            if (!ForgeEvents.isAerolithNearby((Player)player).isEmpty()) {
                blackHole = list.get(0).getAction().equalsIgnoreCase("BLACK_HOLE");
                if (fogTick < 1.0f) {
                    fogTick = Math.min(1.0f, fogTick + 0.02f);
                }
            } else {
                blackHole = false;
                if (fogTick > 0.0f) {
                    fogTick = Math.max(0.0f, fogTick - 0.02f);
                }
            }
            for (Entity entity : level.m_104735_()) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6084_() || livingEntity.m_20280_((Entity)player) > 1600.0) continue;
                entity.getCapability(CapabilityRegistry.ENTITY).ifPresent(data -> {
                    if (data.getElements().isEmpty()) {
                        return;
                    }
                    for (Element element : data.getElements().keySet()) {
                        ForgeEvents.drawElementEffects(livingEntity, element);
                    }
                });
            }
        }

        public static void drawElementEffects(LivingEntity livingEntity, Element element) {
            switch (element) {
                case PYRO: {
                    ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
                    break;
                }
                case CRYO: {
                    ParticleUtils.createAABB(livingEntity.m_9236_(), (ParticleOptions)ParticleTypes.f_175821_, livingEntity.m_20191_(), 1, 5.0E-4f);
                    ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
                    break;
                }
                case AERO: {
                    if (livingEntity.f_19797_ % 3 != 0) break;
                    ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
                }
            }
        }

        @SubscribeEvent
        public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
            String name = event.getBossEvent().m_18861_().getString();
            try {
                Entity entity;
                int entityId = Integer.parseInt(name);
                if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId)) instanceof Aerolith) {
                    Aerolith aerolith = (Aerolith)entity;
                    event.setCanceled(true);
                    GuiGraphics guiGraphics = event.getGuiGraphics();
                    PoseStack poseStack = guiGraphics.m_280168_();
                    int x = event.getX();
                    int y = event.getY();
                    int width = Minecraft.m_91087_().m_91268_().m_85445_();
                    int heigh = Minecraft.m_91087_().m_91268_().m_85446_();
                    LerpingBossEvent bossEvent = event.getBossEvent();
                    Component displayName = entity.m_5446_();
                    int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayName);
                    int textX = width / 2 - textWidth / 2;
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, displayName, textX, (int)((float)heigh * 0.12f) - 25, 0xFFFFFF, true);
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)width / 2.0f, (float)heigh * 0.12f, 0.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/aerolith_bossbar.png"), -120, -15, 0.0f, 0.0f, 240, 31, 240, 31);
                    ForgeEvents.drawBar(guiGraphics, new ResourceLocation("etheria", "textures/gui/aerolith_bossbar_fill.png"), -92, -7, 28, 8, 5, bossEvent.m_142717_());
                    int bhProgress = aerolith.getBlackHole();
                    float shield = bhProgress > 0 ? Math.max(0.0f, Math.min(1.0f, (float)bhProgress / 600.0f)) : (float)aerolith.getShield() / 30.0f;
                    if (shield > 0.0f) {
                        ForgeEvents.drawBarShield(guiGraphics, new ResourceLocation("etheria", "textures/gui/aerolith_bossbar_fill.png"), -94, -1, 26, 14, 2, shield);
                    }
                    RenderSystem.disableBlend();
                    poseStack.m_85849_();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public static void drawBar(GuiGraphics gui, ResourceLocation texture, int x, int y, int u, int v, int height, float progress) {
            int total = (int)(164.0f * progress);
            int leftWidth = Math.min(total, 82);
            if (leftWidth > 0) {
                gui.m_280163_(texture, x, y, (float)u, (float)v, leftWidth, height, 240, 31);
            }
            if (total > 82) {
                gui.m_280163_(texture, x + 82 + 20, y, (float)(u + 82 + 20), (float)v, total - 82, height, 240, 31);
            }
        }

        public static void drawBarShield(GuiGraphics gui, ResourceLocation texture, int x, int y, int u, int v, int height, float progress) {
            int total = (int)(170.0f * progress);
            int leftWidth = Math.min(total, 85);
            if (leftWidth > 0) {
                gui.m_280163_(texture, x, y, (float)u, (float)v, leftWidth, height, 240, 31);
            }
            if (total > 85) {
                gui.m_280163_(texture, x + 85 + 18, y, (float)(u + 85 + 18), (float)v, total - 85, height, 240, 31);
            }
        }

        private static List<Aerolith> isAerolithNearby(Player player) {
            if (player == null) {
                return new ArrayList<Aerolith>();
            }
            Level level = player.m_9236_();
            AABB searchArea = player.m_20191_().m_82400_(24.0);
            List nearbyMobs = level.m_45976_(Aerolith.class, searchArea);
            return nearbyMobs;
        }

        @SubscribeEvent
        public static void onRenderFog(ViewportEvent.RenderFog event) {
            if (fogTick > 0.0f) {
                float var1 = Mth.m_14179_((float)fogTick, (float)event.getNearPlaneDistance(), (float)6.0f);
                float var2 = Mth.m_14179_((float)fogTick, (float)event.getFarPlaneDistance(), (float)32.0f);
                event.setNearPlaneDistance(var1);
                event.setFarPlaneDistance(var2);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onFogColor(ViewportEvent.ComputeFogColor event) {
            if (fogTick > 0.0f) {
                float currentRed = event.getRed();
                float currentGreen = event.getGreen();
                float currentBlue = event.getBlue();
                if (blackHole) {
                    event.setRed(Mth.m_14179_((float)fogTick, (float)currentRed, (float)0.19215687f));
                    event.setGreen(Mth.m_14179_((float)fogTick, (float)currentGreen, (float)0.13333334f));
                    event.setBlue(Mth.m_14179_((float)fogTick, (float)currentBlue, (float)0.23529412f));
                } else {
                    event.setRed(Mth.m_14179_((float)fogTick, (float)currentRed, (float)0.7372549f));
                    event.setGreen(Mth.m_14179_((float)fogTick, (float)currentGreen, (float)0.7372549f));
                    event.setBlue(Mth.m_14179_((float)fogTick, (float)currentBlue, (float)0.7372549f));
                }
            }
        }

        @SubscribeEvent
        public static void onLevelRender(RenderLevelStageEvent event) {
        }

        @SubscribeEvent
        public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
            if (Minecraft.m_91087_().f_91080_ != null) {
                return;
            }
            float delta = Minecraft.m_91087_().m_91296_();
            float ticksExistedDelta = 0.0f;
            if (Minecraft.m_91087_().f_91074_ != null) {
                ticksExistedDelta = (float)Minecraft.m_91087_().f_91074_.f_19797_ + delta;
            }
            if (!Minecraft.m_91087_().m_91104_()) {
                float shakeAmplitude = 0.0f;
                for (ScreenShakeEntity ScreenShake : Minecraft.m_91087_().f_91074_.m_9236_().m_45976_(ScreenShakeEntity.class, Minecraft.m_91087_().f_91074_.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                    if (!(ScreenShake.m_20270_((Entity)Minecraft.m_91087_().f_91074_) < ScreenShake.getRadius())) continue;
                    shakeAmplitude += ScreenShake.getShakeAmount((Player)Minecraft.m_91087_().f_91074_, delta);
                }
                if (shakeAmplitude > 1.0f) {
                    shakeAmplitude = 1.0f;
                }
                float pitchOffset = (float)((double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0);
                float yawOffset = (float)((double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0);
                float rollOffset = (float)((double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0);
                event.setPitch(event.getPitch() + pitchOffset);
                event.setYaw(event.getYaw() + yawOffset);
                event.setRoll(event.getRoll() + rollOffset);
                lastShakePitch = pitchOffset;
                lastShakeYaw = yawOffset;
                lastShakeRoll = rollOffset;
            } else {
                lastShakePitch = 0.0f;
                lastShakeYaw = 0.0f;
                lastShakeRoll = 0.0f;
            }
        }
    }
}

