/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.mixin;

import com.ishland.c2me.base.common.scheduler.IVanillaChunkManager;
import com.ishland.c2me.base.common.scheduler.ThreadLocalWorldGenSchedulingState;
import com.ishland.c2me.base.common.util.SneakyThrow;
import com.ishland.c2me.base.mixin.access.IThreadedAnvilChunkStorage;
import com.ishland.c2me.opts.chunk_access.common.CurrentWorldGenState;
import com.ishland.c2me.threading.worldgen.common.ChunkStatusUtils;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.ishland.c2me.threading.worldgen.common.IChunkStatus;
import com.ishland.c2me.threading.worldgen.common.IWorldGenLockable;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkStatus.class})
public abstract class MixinChunkStatus
implements IChunkStatus {
    @Shadow
    @Final
    private ChunkStatus.GenerationTask f_62335_;
    @Shadow
    @Final
    private int f_62337_;
    private int reducedTaskRadius = -1;

    @Shadow
    public static List<ChunkStatus> m_62349_() {
        throw new AbstractMethodError();
    }

    @Shadow
    public abstract String toString();

    @Override
    public void calculateReducedTaskRadius() {
        if (this.f_62337_ == 0) {
            this.reducedTaskRadius = 0;
        } else {
            for (int i = 0; i <= this.f_62337_; ++i) {
                ChunkStatus status = ChunkStatus.m_156185_((int)(ChunkStatus.m_62370_((ChunkStatus)((ChunkStatus)this)) + i));
                if (status.m_62445_() > ChunkStatus.f_62317_.m_62445_()) continue;
                this.reducedTaskRadius = Math.min(this.f_62337_, Math.max(0, i - 1));
                break;
            }
        }
        if (this == ChunkStatus.f_62323_) {
            this.reducedTaskRadius = 1;
        }
        System.out.printf("%s task radius: %d -> %d%n", this, this.f_62337_, this.reducedTaskRadius);
    }

    @Override
    public int getReducedTaskRadius() {
        return this.reducedTaskRadius;
    }

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    @Dynamic
    private static void onCLInit(CallbackInfo info) {
        for (ChunkStatus chunkStatus : MixinChunkStatus.m_62349_()) {
            ((IChunkStatus)chunkStatus).calculateReducedTaskRadius();
        }
    }

    @Overwrite
    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_280308_(Executor executor, ServerLevel world, ChunkGenerator chunkGenerator, StructureTemplateManager structureManager, ThreadedLevelLightEngine lightingProvider, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> function, List<ChunkAccess> list) {
        CompletionStage completableFuture;
        ChunkStatus thiz = (ChunkStatus)this;
        ChunkAccess targetChunk = list.get(list.size() / 2);
        ProfiledDuration finishable = JvmProfiler.f_185340_.m_183559_(targetChunk.m_7697_(), world.m_46472_(), this.toString());
        Supplier<CompletableFuture> generationTask = () -> {
            try {
                CurrentWorldGenState.setCurrentRegion((WorldGenRegion)new WorldGenRegion(world, list, thiz, -1));
                CompletableFuture completableFuture = this.f_62335_.m_214024_(thiz, executor, world, chunkGenerator, structureManager, lightingProvider, function, list, targetChunk);
                return completableFuture;
            }
            finally {
                CurrentWorldGenState.clearCurrentRegion();
            }
        };
        if (targetChunk.m_6415_().m_62427_(thiz)) {
            completableFuture = generationTask.get();
        } else {
            ChunkHolder holder = ThreadLocalWorldGenSchedulingState.getChunkHolder();
            ChunkMap tacs = world.m_7726_().f_8325_;
            if (holder != null && ChunkStatusUtils.isCancelled(holder, thiz)) {
                completableFuture = ChunkHolder.f_139996_;
                ((IThreadedAnvilChunkStorage)tacs).invokeReleaseLightTicket(targetChunk.m_7697_());
            } else {
                int lockRadius = Config.reduceLockRadius && this.reducedTaskRadius != -1 ? this.reducedTaskRadius : this.f_62337_;
                completableFuture = ChunkStatusUtils.runChunkGenWithLock(targetChunk.m_7697_(), thiz, holder, lockRadius, ((IVanillaChunkManager)tacs).c2me$getSchedulingManager(), this == ChunkStatus.f_62323_, ((IWorldGenLockable)world).getWorldGenChunkLock(), () -> ChunkStatusUtils.getThreadingType(thiz).runTask(((IWorldGenLockable)world).getWorldGenSingleThreadedLock(), generationTask)).exceptionally(t -> {
                    Throwable actual = t;
                    while (actual instanceof CompletionException) {
                        actual = t.getCause();
                    }
                    if (actual instanceof CancellationException) {
                        return ChunkHolder.f_139995_;
                    }
                    SneakyThrow.sneaky((Throwable)t);
                    return null;
                });
            }
        }
        completableFuture.exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
        return completableFuture.thenApply(either -> {
            ProtoChunk protoChunk;
            Object patt7468$temp;
            if (either.left().isPresent() && (patt7468$temp = either.left().get()) instanceof ProtoChunk && !(protoChunk = (ProtoChunk)patt7468$temp).m_6415_().m_62427_(thiz)) {
                protoChunk.m_7150_(thiz);
            }
            if (finishable != null) {
                finishable.m_185413_();
            }
            return either;
        });
    }
}

