/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.mixin;

import com.ishland.c2me.threading.worldgen.common.Config;
import com.ishland.c2me.threading.worldgen.common.IChunkStatus;
import com.ishland.c2me.threading.worldgen.common.debug.StacktraceRecorder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldGenRegion.class})
public class MixinChunkRegion {
    @Shadow
    @Final
    private ChunkAccess f_143479_;
    @Shadow
    @Final
    private ChunkPos f_9487_;
    @Shadow
    @Final
    private ChunkPos f_9488_;
    @Shadow
    @Final
    private static Logger f_9474_;
    @Shadow
    @Final
    private ChunkStatus f_143480_;
    private ChunkPos lowerReducedCorner = null;
    private ChunkPos upperReducedCorner = null;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(ServerLevel world, List<ChunkAccess> list, ChunkStatus chunkStatus, int placementRadius, CallbackInfo ci) {
        if (Config.reduceLockRadius) {
            int reducedTaskRadius = ((IChunkStatus)chunkStatus).getReducedTaskRadius();
            this.lowerReducedCorner = new ChunkPos(this.f_143479_.m_7697_().f_45578_ - reducedTaskRadius, this.f_143479_.m_7697_().f_45579_ - reducedTaskRadius);
            this.upperReducedCorner = new ChunkPos(this.f_143479_.m_7697_().f_45578_ + reducedTaskRadius, this.f_143479_.m_7697_().f_45579_ + reducedTaskRadius);
        } else {
            this.lowerReducedCorner = this.f_9487_;
            this.upperReducedCorner = this.f_9488_;
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/chunk/ChunkStatus;Z)Lnet/minecraft/world/chunk/Chunk;"}, at={@At(value="HEAD")})
    private void onGetChunk(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, CallbackInfoReturnable<ChunkAccess> cir) {
        if (Config.reduceLockRadius && !this.isInsideReducedTaskRadius(chunkX, chunkZ) && this.f_143480_ != ChunkStatus.f_62316_) {
            StacktraceRecorder.record();
        }
    }

    @Inject(method={"isChunkLoaded"}, at={@At(value="HEAD")})
    private void onIsChunkLoaded(int chunkX, int chunkZ, CallbackInfoReturnable<Boolean> cir) {
        if (Config.reduceLockRadius && !this.isInsideReducedTaskRadius(chunkX, chunkZ) && this.f_143480_ != ChunkStatus.f_62316_) {
            StacktraceRecorder.record();
        }
    }

    @Unique
    private boolean isInsideReducedTaskRadius(int chunkX, int chunkZ) {
        return chunkX >= this.lowerReducedCorner.f_45578_ && chunkX <= this.upperReducedCorner.f_45578_ && chunkZ >= this.lowerReducedCorner.f_45579_ && chunkZ <= this.upperReducedCorner.f_45579_;
    }
}

