/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.common.debug;

import com.google.common.collect.Sets;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class StacktraceRecorder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean doRecord = Config.reduceLockRadius && Boolean.getBoolean("com.ishland.c2me.common.threading.worldgen.debug.DebugReducedLockRadius");
    private static final int recordFrequency = Mth.m_14045_((int)Integer.getInteger("com.ishland.c2me.common.threading.worldgen.debug.DebugReducedLockRadiusFrequency", 4), (int)1, (int)16);
    private static final long frequencyBitMask = (1L << recordFrequency) - 1L;
    private static final Set<StacktraceHolder> recordedStacktraces = Sets.newConcurrentHashSet();
    private static final AtomicLong sampledCount = new AtomicLong();

    public static void record() {
        if (!doRecord) {
            return;
        }
        if ((sampledCount.incrementAndGet() & frequencyBitMask) != 0L) {
            return;
        }
        StacktraceHolder stacktraceHolder = new StacktraceHolder();
        if (recordedStacktraces.add(stacktraceHolder) && stacktraceHolder.needPrint()) {
            LOGGER.warn("Potential dangerous call with reducedLockRadius", stacktraceHolder.throwable);
        }
    }

    public static class StacktraceHolder {
        private static final String StructureProcessor$process = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor", "m_7382_", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;)Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;");
        private static final String BlendingData$getBlendingData = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.levelgen.blending.BlendingData", "m_190304_", "(Lnet/minecraft/server/level/WorldGenRegion;II)Lnet/minecraft/world/level/levelgen/blending/BlendingData;");
        private static final String ChunkGenerator$carve = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.chunk.ChunkGenerator", "m_213679_", "(Lnet/minecraft/server/level/WorldGenRegion;JLnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/biome/BiomeManager;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/world/level/levelgen/GenerationStep$Carving;)V");
        private static final String SpawnHelper$populateEntities = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.NaturalSpawner", "m_220450_", "(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/level/biome/Biome;Lnet/minecraft/world/level/ChunkPos;Ljava/util/Random;)V");
        private static final String StructureAccessor$method_41032 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.StructureManager", "m_220480_", "(Lnet/minecraft/core/SectionPos;Lnet/minecraft/class_5312;)Ljava/util/List;");
        private static final String BiomeAccess$Storage$getBiomeForNoiseGen = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.biome.BiomeManager$NoiseBiomeSource", "m_203495_", "(III)Lnet/minecraft/core/Holder;");
        private static final String BlockCollisionSpliterator$getChunk = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.world.level.BlockCollisions", "m_186411_", "(II)Lnet/minecraft/world/level/BlockGetter;");
        @NotNull
        private final StackTraceElement[] stackTrace;
        private final Throwable throwable = new Throwable();

        public StacktraceHolder() {
            this.stackTrace = this.throwable.getStackTrace();
        }

        public boolean needPrint() {
            for (StackTraceElement stackTraceElement : this.stackTrace) {
                if (stackTraceElement.getMethodName().equals("method_26971")) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(RuleProcessor.class.getName()) && stackTraceElement.getMethodName().equals(StructureProcessor$process)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(BlendingData.class.getName()) && stackTraceElement.getMethodName().equals(BlendingData$getBlendingData)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(NoiseBasedChunkGenerator.class.getName()) && stackTraceElement.getMethodName().equals(ChunkGenerator$carve)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(NaturalSpawner.class.getName()) && stackTraceElement.getMethodName().equals(SpawnHelper$populateEntities)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(StructureManager.class.getName()) && stackTraceElement.getMethodName().equals(StructureAccessor$method_41032)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(LevelReader.class.getName()) && stackTraceElement.getMethodName().equals(BiomeAccess$Storage$getBiomeForNoiseGen)) {
                    return false;
                }
                if (stackTraceElement.getClassName().equals(BlockCollisions.class.getName()) && stackTraceElement.getMethodName().equals(BlockCollisionSpliterator$getChunk)) {
                    return false;
                }
                if (!stackTraceElement.getClassName().equals("me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper")) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "StacktraceHolder{stackTrace=" + Arrays.toString(this.stackTrace) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StacktraceHolder that = (StacktraceHolder)o;
            return Arrays.equals(this.stackTrace, that.stackTrace);
        }

        public int hashCode() {
            return Arrays.hashCode(this.stackTrace);
        }
    }
}

