/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.common;

import com.google.common.base.Preconditions;
import com.ibm.asyncutil.locks.AsyncLock;
import com.ibm.asyncutil.locks.AsyncNamedLock;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.NeighborLockingTask;
import com.ishland.c2me.base.common.scheduler.SchedulingManager;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class ChunkStatusUtils {
    public static final BooleanSupplier FALSE_SUPPLIER = () -> false;

    public static ChunkStatusThreadingType getThreadingType(ChunkStatus status) {
        if (status.equals(ChunkStatus.f_62315_) || status.equals(ChunkStatus.f_62316_) || status.equals(ChunkStatus.f_62317_) || status.equals(ChunkStatus.f_62318_) || status.equals(ChunkStatus.f_62324_) || status.equals(ChunkStatus.f_62319_) || status.equals(ChunkStatus.f_62320_)) {
            return ChunkStatusThreadingType.PARALLELIZED;
        }
        if (status.equals(ChunkStatus.f_62322_)) {
            return Config.allowThreadedFeatures ? ChunkStatusThreadingType.PARALLELIZED : ChunkStatusThreadingType.SINGLE_THREADED;
        }
        if (status.equals(ChunkStatus.f_279614_) || status.equals(ChunkStatus.f_62323_)) {
            return ChunkStatusThreadingType.AS_IS;
        }
        return ChunkStatusThreadingType.AS_IS;
    }

    public static <T> CompletableFuture<T> runChunkGenWithLock(ChunkPos target, ChunkStatus status, ChunkHolder holder, int radius, SchedulingManager schedulingManager, boolean async, AsyncNamedLock<ChunkPos> chunkLock, Supplier<CompletableFuture<T>> action) {
        Preconditions.checkNotNull((Object)status);
        BooleanSupplier isCancelled = holder != null ? () -> ChunkStatusUtils.isCancelled(holder, status) : FALSE_SUPPLIER;
        LongArrayList lockTargets = new LongArrayList((2 * radius + 1) * (2 * radius + 1));
        for (int x = target.f_45578_ - radius; x <= target.f_45578_ + radius; ++x) {
            for (int z = target.f_45579_ - radius; z <= target.f_45579_ + radius; ++z) {
                lockTargets.add(ChunkPos.m_45589_((int)x, (int)z));
            }
        }
        NeighborLockingTask task = new NeighborLockingTask(schedulingManager, target.m_45588_(), lockTargets.toLongArray(), isCancelled, action, "%s %s".formatted(target.toString(), status.toString()), async);
        return task.getFuture();
    }

    public static boolean isCancelled(ChunkHolder holder, ChunkStatus targetStatus) {
        return ChunkLevel.m_287158_((int)holder.m_140093_()).m_62445_() < targetStatus.m_62445_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ChunkStatusThreadingType {
        PARALLELIZED{

            @Override
            public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> completableFuture) {
                return CompletableFuture.supplyAsync(completableFuture, GlobalExecutors.executor).thenCompose(Function.identity());
            }
        }
        ,
        SINGLE_THREADED{

            @Override
            public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> completableFuture) {
                Preconditions.checkNotNull((Object)lock);
                return lock.acquireLock().toCompletableFuture().thenComposeAsync(lockToken -> {
                    try {
                        CompletionStage completionStage = (CompletionStage)completableFuture.get();
                        return completionStage;
                    }
                    finally {
                        lockToken.releaseLock();
                    }
                }, (Executor)GlobalExecutors.executor);
            }
        }
        ,
        AS_IS{

            @Override
            public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> runTask(AsyncLock lock, Supplier<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> completableFuture) {
                return completableFuture.get();
            }
        };


        public abstract CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> runTask(AsyncLock var1, Supplier<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> var2);
    }
}

