/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.BigShulkerBulletEntity;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Shulker_MimicEntity
extends IAnimatedMonster {
    public final int SHOOT_COOLDOWN = 30;
    public int shoot_cooldown = 30;
    public int backstepType = 1;
    public int shootType = 1;
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState biteAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState backstepDashAnimationState = new AnimationState();
    public AnimationState tripleShootAnimationState = new AnimationState();
    public AnimationState tripleShootTp1AnimationState = new AnimationState();
    public AnimationState tripleShootTp2AnimationState = new AnimationState();
    public AnimationState backstepAnimationState = new AnimationState();
    public AnimationState doubleSlashAnimationState = new AnimationState();
    public AnimationState pullHitAnimationState = new AnimationState();

    public Shulker_MimicEntity(EntityType<? extends IAnimatedMonster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 20;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    @Override
    public void m_8119_() {
        if (this.shoot_cooldown > 0) {
            --this.shoot_cooldown;
        }
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        }
        super.m_8119_();
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 25, 25, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 51, 25, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null && Shulker_MimicEntity.this.getNextRandomBackstep() == 2;
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 25, 25, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null && Shulker_MimicEntity.this.getNextRandomBackstep() == 1;
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 42, 42, 12.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null && Shulker_MimicEntity.this.shoot_cooldown <= 0 && Shulker_MimicEntity.this.getNextRandomShootType() == 1;
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.shoot_cooldown = 30;
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 9, 0, 48, 48, 12.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null && Shulker_MimicEntity.this.shoot_cooldown <= 0 && Shulker_MimicEntity.this.getNextRandomShootType() == 2;
            }

            @Override
            public void m_8037_() {
                if (Shulker_MimicEntity.this.attackTicks == 33) {
                    // empty if block
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.shoot_cooldown = 30;
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 10, 0, 48, 48, 12.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null && Shulker_MimicEntity.this.shoot_cooldown <= 0 && Shulker_MimicEntity.this.getNextRandomShootType() == 3;
            }

            @Override
            public void m_8037_() {
                if (Shulker_MimicEntity.this.attackTicks == 33) {
                    // empty if block
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.shoot_cooldown = 30;
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 7, 0, 58, 19, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null;
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 8, 0, 47, 20, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Shulker_MimicEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Shulker_MimicEntity.this.m_5448_() != null;
            }

            @Override
            public void m_8041_() {
                Shulker_MimicEntity.this.randomizeAttackPatterns();
                super.m_8041_();
            }
        });
    }

    public void randomizeAttackPatterns() {
        this.randomizeNextShootType();
        this.randomizeNextBackstepType();
    }

    public int getNextRandomBackstep() {
        return this.backstepType;
    }

    public void randomizeNextBackstepType() {
        switch (this.f_19796_.m_188503_(2)) {
            case 0: {
                this.backstepType = 2;
                break;
            }
            case 1: {
                this.backstepType = 2;
            }
        }
    }

    public int getNextRandomShootType() {
        return this.shootType;
    }

    public void randomizeNextShootType() {
        switch (this.f_19796_.m_188503_(4)) {
            case 0: {
                this.shootType = 1;
                break;
            }
            case 1: {
                this.shootType = 2;
                break;
            }
            case 2: 
            case 4: {
                this.shootType = 3;
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 12.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.ShulkerMimicHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 200.0;
        double baseAttackDamage = 12.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12407_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12415_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12413_;
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)ModConfig.MOB_CONFIG.Shulkerprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268434_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        this.UpdateWithAttack();
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "bite") {
            return this.biteAnimationState;
        }
        if (input == "backstep_charge") {
            return this.backstepDashAnimationState;
        }
        if (input == "backstep") {
            return this.backstepAnimationState;
        }
        if (input == "triple_shoot") {
            return this.tripleShootAnimationState;
        }
        if (input == "triple_shoot_tp1") {
            return this.tripleShootTp1AnimationState;
        }
        if (input == "triple_shoot_tp2") {
            return this.tripleShootTp2AnimationState;
        }
        if (input == "pull_hit") {
            return this.pullHitAnimationState;
        }
        if (input == "double_slash") {
            return this.doubleSlashAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.biteAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.backstepDashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.backstepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.tripleShootAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.pullHitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.doubleSlashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.tripleShootTp1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.tripleShootTp2AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.biteAnimationState.m_216973_();
        this.backstepDashAnimationState.m_216973_();
        this.tripleShootAnimationState.m_216973_();
        this.backstepAnimationState.m_216973_();
        this.pullHitAnimationState.m_216973_();
        this.doubleSlashAnimationState.m_216973_();
        this.tripleShootTp1AnimationState.m_216973_();
        this.tripleShootTp2AnimationState.m_216973_();
    }

    public void backStep(float backstepStrenght) {
        float flipStrenght = backstepStrenght;
        float yaw = (float)Math.toRadians(this.m_146908_() + 90.0f);
        Vec3 dodgePos = this.m_20184_().m_82520_((double)flipStrenght * Math.cos(yaw), 0.0, (double)flipStrenght * Math.sin(yaw));
        this.m_20334_(dodgePos.f_82479_, dodgePos.f_82480_, dodgePos.f_82481_);
    }

    public void UpdateWithAttack() {
        float offset;
        double vecZ;
        double vecX;
        double theta;
        float f1;
        BigShulkerBulletEntity witherskull;
        double d5;
        double d3;
        double d2;
        double d1;
        float smallBulletSize = 0.75f;
        float mediumBulletSize = 1.0f;
        float biggieBulletSize = 1.5f;
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 7) {
                // empty if block
            }
            if (this.attackTicks == 8) {
                this.m_5496_(SoundEvents.f_11865_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 10) {
                this.AreaAttack(6.0f, 4.0f, 180.0f, 14.0f, 100, true, false);
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks > 3 && this.attackTicks < 7) {
                this.backStep(-0.75f);
            }
            if (this.attackTicks == 23) {
                this.calculatedDash(0.35f);
            }
            if (this.attackTicks == 31) {
                this.StraightLineAreaAttack(0.05f, 4.0f, 100, 20.0f, true);
            }
        }
        if (this.getAttackState() == 5 && this.attackTicks > 3 && this.attackTicks < 7) {
            this.backStep(-0.75f);
        }
        if (this.getAttackState() == 6) {
            double d4;
            double d0;
            if (this.attackTicks == 10) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, smallBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 21) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, mediumBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 32) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, biggieBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
        }
        if (this.getAttackState() == 9) {
            if (this.attackTicks == 20 && this.m_5448_() != null) {
                float f = Mth.m_14089_((float)(this.m_5448_().f_20883_ * ((float)Math.PI / 180)));
                f1 = Mth.m_14031_((float)(this.m_5448_().f_20883_ * ((float)Math.PI / 180)));
                theta = (double)this.m_5448_().f_20883_ * (Math.PI / 180);
                vecX = Math.cos(theta += 1.5707963267948966);
                vecZ = Math.sin(theta);
                float vec = -5.0f;
                offset = 2.0f;
                if (this.m_9236_() instanceof ServerLevel) {
                    this.m_6021_(this.m_5448_().m_20185_() + (double)vec * vecX + (double)(f * offset), this.m_5448_().m_20186_(), (float)(this.m_5448_().m_20189_() + (double)vec * vecZ + (double)(f1 * offset)));
                }
            }
            if (this.attackTicks == 10) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, smallBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 28) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, mediumBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 32) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, biggieBulletSize);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
        }
        if (this.getAttackState() == 10) {
            if (this.attackTicks == 33 && this.m_5448_() != null) {
                float f = Mth.m_14089_((float)(this.m_5448_().f_20883_ * ((float)Math.PI / 180)));
                f1 = Mth.m_14031_((float)(this.m_5448_().f_20883_ * ((float)Math.PI / 180)));
                theta = (double)this.m_5448_().f_20883_ * (Math.PI / 180);
                vecX = Math.cos(theta += 1.5707963267948966);
                vecZ = Math.sin(theta);
                float vec = -5.0f;
                offset = 2.0f;
                if (this.m_9236_() instanceof ServerLevel) {
                    this.m_6021_(this.m_5448_().m_20185_() + (double)vec * vecX + (double)(f * offset), this.m_5448_().m_20186_(), (float)(this.m_5448_().m_20189_() + (double)vec * vecZ + (double)(f1 * offset)));
                }
            }
            if (this.attackTicks == 10) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, 1.0f);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 21) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, 1.5f);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
            if (this.attackTicks == 38) {
                this.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    double d0 = this.m_20185_();
                    d1 = this.m_20186_() + 2.0;
                    d2 = this.m_20189_();
                    d3 = this.m_5448_().m_20185_() - d0;
                    double d4 = this.m_5448_().m_20186_() + 1.5 - d1;
                    d5 = this.m_5448_().m_20189_() - d2;
                    witherskull = new BigShulkerBulletEntity(this.m_9236_(), (LivingEntity)this, d3, d4, d5, 2.0f);
                    witherskull.m_5602_((Entity)this);
                    witherskull.m_20343_(d0, d1, d2);
                    this.m_9236_().m_7967_((Entity)witherskull);
                }
            }
        }
        if (this.getAttackState() == 7) {
            int i = 24;
            int j = 2;
            while (i <= 29) {
                if (this.attackTicks == i) {
                    this.SpawnDamagingBlocks(0.75f, j, 4.0f, 2.0f, 1.0f, 1.0f, 0.05f);
                }
                if (this.attackTicks == 24) {
                    this.m_5496_(SoundEvents.f_11892_, 1.0f, 1.0f);
                    this.AreaAttack(5.0f, 4.0f, 180.0f, 20.0f, 140, true, false);
                    this.SpawnCircleParticle(2.0f, 0.0f, 30.0f, true, 3.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.attackTicks > 24 && this.attackTicks < 46) {
                    if (this.m_9236_().f_46443_) {
                        float yaw = (float)Math.toRadians(-this.m_146908_());
                        float pitch = (float)Math.toRadians(-this.m_146909_());
                        float spread = 0.7f;
                        float speed = 2.0f;
                        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
                        float yComp = (float)Math.sin(pitch);
                        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
                        double theta2 = (double)this.m_146908_() * (Math.PI / 180);
                        double vecX2 = Math.cos(theta2 += 1.5707963267948966);
                        double vecZ2 = Math.sin(theta2);
                        double vec = 2.0;
                        if (this.m_9236_().f_46443_) {
                            for (int g = 0; g < 3; ++g) {
                                double xSpeed = (double)(speed * xComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - xComp * xComp);
                                double ySpeed = (double)(speed * yComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - yComp * yComp);
                                double zSpeed = (double)(speed * zComp) + (double)(spread * 1.0f * (this.f_19796_.m_188501_() * 2.0f - 1.0f)) * Math.sqrt(1.0f - zComp * zComp);
                                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + vec * vecX2, this.m_20186_() + 2.0, this.m_20189_() + vec * vecZ2, xSpeed, ySpeed, zSpeed);
                            }
                        }
                    }
                    this.PushEntitiesAwayInFrontOf(0.0025f, 14.0f, 0, 5.0f);
                }
                i += 2;
                ++j;
            }
        }
        if (this.getAttackState() == 8) {
            if (this.attackTicks == 12) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
                this.calculatedDash(0.15f);
            }
            if (this.attackTicks == 15) {
                this.AreaAttack(4.5f, 0.75f, 180.0f, 18.0f, 100, false, false);
            }
            if (this.attackTicks == 25) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
                this.calculatedDash(0.15f);
            }
            if (this.attackTicks == 28) {
                this.AreaAttack(4.5f, 0.75f, 180.0f, 18.0f, 100, false, false);
            }
        }
    }

    public Direction.Axis getAttachFace() {
        return Direction.Axis.Y;
    }

    public boolean m_7337_(Entity pEntity) {
        return true;
    }

    private void StraightLineAreaAttack(float RangeXZ, float range, int brokenShieldTicks, float damage, boolean launch) {
        double rad = Math.toRadians(this.m_146908_() + 90.0f);
        double xRange = (double)range * Math.cos(rad);
        double zRange = (double)range * Math.sin(rad);
        AABB attackRange = this.m_20191_().m_82377_((double)RangeXZ, 4.0, (double)RangeXZ).m_82363_(xRange, 0.0, zRange);
        for (LivingEntity entityHit : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
            if (this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get()));
            if (flag) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 0.5f);
            }
            if (flag && launch) {
                this.launch(entityHit, true);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            Shulker_MimicEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    private void PushEntitiesAwayInFrontOf(float RangeXZ, float range, int brokenShieldTicks, float damage) {
        double rad = Math.toRadians(this.m_146908_() + 90.0f);
        double xRange = (double)range * Math.cos(rad);
        double zRange = (double)range * Math.sin(rad);
        AABB attackRange = this.m_20191_().m_82377_((double)RangeXZ, 4.0, (double)RangeXZ).m_82363_(xRange, 0.0, zRange);
        for (LivingEntity entityHit : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
            if (this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get()));
            if (flag) {
                this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GRAVITY_PULL.get(), 100, 2));
            }
            if (entityHit instanceof Player && ((Player)entityHit).m_150110_().f_35934_ || this.m_7307_((Entity)entityHit)) continue;
            Vec3 diff = entityHit.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 0.0, 0.0));
            diff = diff.m_82541_().m_82490_(-0.06);
            entityHit.m_20256_(entityHit.m_20184_().m_82546_(diff));
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            Shulker_MimicEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int brokenShieldTicks, boolean canlaunch, boolean canStun) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Shulker_MimicEntity || entityHit == this) continue;
            if (this.m_5448_() != null) {
                float m = this.m_5448_().m_21233_() * 0.03f;
                boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get() + (double)m));
                if (flag) {
                    if (canStun) {
                        if (entityHit == this.m_5448_()) {
                            this.m_5496_(SoundEvents.f_11669_, 2.0f, 1.0f);
                        }
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 80, 1));
                    }
                    if (canlaunch) {
                        this.launch(entityHit, true);
                    }
                }
            } else {
                boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
                if (flag && canlaunch) {
                    this.launch(entityHit, true);
                }
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            Shulker_MimicEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness shulkermimic$crackiness : BY_DAMAGE) {
                if (!(pFraction < shulkermimic$crackiness.fraction)) continue;
                return shulkermimic$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

