/*
 * Decompiled with CFR 0.152.
 */
package me.odin.portal.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod(value="portalrestrict")
public class Main {
    public static final String MODID = "portalrestrict";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Lazy<Map<String, Requirement>> REQUIRED = Lazy.of(Main::loadRequirementsFromJson);
    private static final String DIMENSIONS_JSON = "portalrestrict-dimensions.json";
    private static boolean PER_PLAYER_UNLOCK_RUNTIME = true;
    private static boolean REQUIRE_ITEM_UNTIL_VISITED_RUNTIME = true;
    private static String GLOBAL_FALLBACK_MESSAGE = "\u00a7cYou need {item} to enter the {dimension}!";

    public Main() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Map loaded = (Map)REQUIRED.get();
        LOGGER.info("[PortalRestrict] Mod initialized. Loaded {} requirement(s).", (Object)loaded.size());
        LOGGER.debug("[PortalRestrict] Loaded keys: {}", loaded.keySet());
    }

    private static Map<String, Requirement> loadRequirementsFromJson() {
        HashMap<String, Requirement> map;
        block14: {
            map = new HashMap<String, Requirement>();
            try {
                String jsonText;
                File jsonFile;
                File configDir = new File("config");
                if (!configDir.exists() && !configDir.mkdirs()) {
                    LOGGER.warn("[PortalRestrict] Could not create config directory: {}", (Object)configDir.getAbsolutePath());
                }
                if (!(jsonFile = new File(configDir, DIMENSIONS_JSON)).exists()) {
                    Main.createDefaultJson(jsonFile);
                    LOGGER.info("[PortalRestrict] Created default {}", (Object)jsonFile.getAbsolutePath());
                }
                if ((jsonText = Main.readJsonWithHashComments(jsonFile)) == null || jsonText.isBlank()) {
                    LOGGER.warn("[PortalRestrict] JSON config is empty after preprocessing; no entries loaded.");
                    return map;
                }
                JsonElement root = JsonParser.parseString((String)jsonText);
                if (root.isJsonArray()) {
                    Main.parseEntriesArray(root.getAsJsonArray(), map);
                    break block14;
                }
                if (root.isJsonObject()) {
                    JsonObject rootObj = root.getAsJsonObject();
                    if (rootObj.has("globalFallbackMessage") && rootObj.get("globalFallbackMessage").isJsonPrimitive()) {
                        try {
                            GLOBAL_FALLBACK_MESSAGE = rootObj.get("globalFallbackMessage").getAsString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (rootObj.has("unlockBehavior") && rootObj.get("unlockBehavior").isJsonObject()) {
                        JsonObject ub = rootObj.getAsJsonObject("unlockBehavior");
                        PER_PLAYER_UNLOCK_RUNTIME = ub.has("per_player_unlock") && ub.get("per_player_unlock").getAsBoolean();
                        REQUIRE_ITEM_UNTIL_VISITED_RUNTIME = ub.has("require_item_until_visited") && ub.get("require_item_until_visited").getAsBoolean();
                        LOGGER.info("[PortalRestrict] unlockBehavior loaded from JSON: per_player_unlock={}, require_item_until_visited={}", (Object)PER_PLAYER_UNLOCK_RUNTIME, (Object)REQUIRE_ITEM_UNTIL_VISITED_RUNTIME);
                    } else {
                        LOGGER.debug("[PortalRestrict] No unlockBehavior in JSON; using defaults per_player_unlock={}, require_item_until_visited={}", (Object)PER_PLAYER_UNLOCK_RUNTIME, (Object)REQUIRE_ITEM_UNTIL_VISITED_RUNTIME);
                    }
                    if (rootObj.has("entries") && rootObj.get("entries").isJsonArray()) {
                        Main.parseEntriesArray(rootObj.getAsJsonArray("entries"), map);
                    } else {
                        LOGGER.warn("[PortalRestrict] JSON config has no 'entries' array; no dimension entries loaded.");
                    }
                    break block14;
                }
                LOGGER.warn("[PortalRestrict] Unexpected JSON root type; expected object or array.");
            }
            catch (Exception ex) {
                LOGGER.error("[PortalRestrict] Failed to load JSON config.", (Throwable)ex);
            }
        }
        LOGGER.info("[PortalRestrict] Loaded {} requirement(s) from JSON.", (Object)map.size());
        return map;
    }

    private static void parseEntriesArray(JsonArray arr, Map<String, Requirement> map) {
        for (JsonElement el : arr) {
            try {
                if (!el.isJsonObject()) {
                    LOGGER.warn("[PortalRestrict] Skipping non-object entry in JSON array.");
                    continue;
                }
                JsonObject obj = el.getAsJsonObject();
                String dimStr = Main.getStringOrNull(obj, "dimension");
                String itemStr = Main.getStringOrNull(obj, "item");
                String accessDenied = Main.getStringOrNull(obj, "accessDeniedMessage");
                String gotItem = Main.getStringOrNull(obj, "gotItemMessage");
                if (dimStr == null || itemStr == null) {
                    LOGGER.warn("[PortalRestrict] Entry missing 'dimension' or 'item'; skipping. Entry: {}", (Object)obj.toString());
                    continue;
                }
                ResourceLocation dimRL = ResourceLocation.m_135820_((String)dimStr);
                ResourceLocation itemRL = ResourceLocation.m_135820_((String)itemStr);
                if (dimRL == null || itemRL == null) {
                    LOGGER.warn("[PortalRestrict] Invalid resource location in entry: dim='{}' item='{}' ; skipping.", (Object)dimStr, (Object)itemStr);
                    continue;
                }
                Item maybe = (Item)BuiltInRegistries.f_257033_.m_7745_(itemRL);
                if (maybe == null) {
                    LOGGER.debug("[PortalRestrict] Item {} not present in registry at load time; will resolve lazily at runtime.", (Object)itemStr);
                }
                String key = dimRL.toString();
                map.put(key, new Requirement(itemStr, accessDenied == null ? "" : accessDenied, gotItem == null ? "" : gotItem, key));
            }
            catch (Exception e) {
                LOGGER.error("[PortalRestrict] Error parsing JSON entry; skipping.", (Throwable)e);
            }
        }
    }

    private static String getStringOrNull(JsonObject obj, String key) {
        if (!obj.has(key) || obj.get(key).isJsonNull()) {
            return null;
        }
        try {
            return obj.get(key).getAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void createDefaultJson(File file) {
        try (FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject root = new JsonObject();
            JsonObject meta = new JsonObject();
            meta.addProperty("description", "PortalRestrict dimensions config. Edit entries to add or change dimension requirements.");
            meta.addProperty("notes", "Lines starting with '#' are treated as comments and ignored.");
            meta.addProperty("placeholders", "Use {dimension} and {item} in messages; they will be replaced at runtime.");
            root.add("meta", (JsonElement)meta);
            root.addProperty("globalFallbackMessage", GLOBAL_FALLBACK_MESSAGE);
            JsonObject unlock = new JsonObject();
            unlock.addProperty("per_player_unlock", Boolean.valueOf(true));
            unlock.addProperty("require_item_until_visited", Boolean.valueOf(true));
            root.add("unlockBehavior", (JsonElement)unlock);
            JsonArray entries = new JsonArray();
            JsonObject o1 = new JsonObject();
            o1.addProperty("dimension", "minecraft:the_nether");
            o1.addProperty("item", "minecraft:diamond");
            o1.addProperty("accessDeniedMessage", "\u00a7cYou need {item} to enter the {dimension}!");
            o1.addProperty("gotItemMessage", "\u00a7aYou have now the power");
            entries.add((JsonElement)o1);
            JsonObject o2 = new JsonObject();
            o2.addProperty("dimension", "example:one");
            o2.addProperty("item", "example:item_one");
            o2.addProperty("accessDeniedMessage", "\u00a7cYou need {item} for {dimension}!");
            o2.addProperty("gotItemMessage", "\u00a7aYou now wield {item}");
            entries.add((JsonElement)o2);
            JsonObject o3 = new JsonObject();
            o3.addProperty("dimension", "example:two");
            o3.addProperty("item", "example:item_two");
            o3.addProperty("accessDeniedMessage", "");
            o3.addProperty("gotItemMessage", "");
            entries.add((JsonElement)o3);
            root.add("entries", (JsonElement)entries);
            gson.toJson((JsonElement)root, (Appendable)fw);
        }
        catch (Exception e) {
            LOGGER.error("[PortalRestrict] Could not create default JSON config file.", (Throwable)e);
        }
    }

    private static String readJsonWithHashComments(File file) {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.startsWith("#")) continue;
                sb.append(line).append('\n');
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("[PortalRestrict] Error reading JSON config file: {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
        }
        br.close();
        return string;
    }

    private Item resolveItem(String itemString) {
        if (itemString == null) {
            return null;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)itemString);
        if (rl == null) {
            return null;
        }
        try {
            Item it = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
            return it;
        }
        catch (Exception e) {
            LOGGER.debug("[PortalRestrict] Exception while resolving item {}: {}", (Object)itemString, (Object)e.getMessage());
            return null;
        }
    }

    @SubscribeEvent
    public void onTravel(EntityTravelToDimensionEvent evt) {
        ResourceKey dimKey;
        Entity entity = evt.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ResourceKey target = evt.getDimension();
        String targetKey = target.m_135782_().toString();
        Requirement req = (Requirement)((Map)REQUIRED.get()).get(targetKey);
        if (req == null) {
            LOGGER.debug("[PortalRestrict] No requirement for '{}'. Available keys: {}", (Object)targetKey, ((Map)REQUIRED.get()).keySet());
            return;
        }
        ServerLevel overworld = player.f_8924_.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        UnlockData data = UnlockData.get(overworld);
        boolean perPlayer = PER_PLAYER_UNLOCK_RUNTIME;
        boolean requireUntilVisited = REQUIRE_ITEM_UNTIL_VISITED_RUNTIME;
        if (requireUntilVisited && data.isUnlocked((ResourceKey<Level>)(dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)req.dimString()))), player.m_20148_(), perPlayer)) {
            return;
        }
        Item required = this.resolveItem(req.itemString());
        if (required == null) {
            LOGGER.debug("[PortalRestrict] Required item '{}' for dimension '{}' not found in registry yet; skipping block check.", (Object)req.itemString(), (Object)req.dimString());
            return;
        }
        if (!this.hasItem(player, required)) {
            evt.setCanceled(true);
            String itemName = required.m_41466_().getString();
            String dimName = this.getFriendlyDimensionName((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)req.dimString())));
            String rawMsg = req.blockMessage();
            String msg = rawMsg != null && !rawMsg.isEmpty() ? rawMsg.replace("{dimension}", dimName).replace("{item}", itemName) : (GLOBAL_FALLBACK_MESSAGE != null ? GLOBAL_FALLBACK_MESSAGE : "").replace("{dimension}", dimName).replace("{item}", itemName);
            if (!msg.isEmpty()) {
                player.m_5661_((Component)Component.m_237113_((String)msg), true);
            }
            Vec3 look = player.m_20154_();
            double horizontalStrength = 1.4;
            double verticalBoost = 0.6;
            player.m_20334_(-look.f_82479_ * horizontalStrength, verticalBoost, -look.f_82481_ * horizontalStrength);
            player.f_19864_ = true;
            player.f_19812_ = true;
            return;
        }
        if (requireUntilVisited) {
            ResourceKey dimKey2 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)req.dimString()));
            UnlockData.get(player.f_8924_.m_129880_(Level.f_46428_)).unlock((ResourceKey<Level>)dimKey2, player.m_20148_(), perPlayer);
        }
    }

    private boolean hasItem(ServerPlayer player, Item required) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || stack.m_41720_() != required) continue;
            return true;
        }
        ItemStack off = player.m_21206_();
        return !off.m_41619_() && off.m_41720_() == required;
    }

    private String getFriendlyDimensionName(ResourceKey<Level> dim) {
        if (dim.equals((Object)Level.f_46428_)) {
            return "Overworld";
        }
        if (dim.equals((Object)Level.f_46429_)) {
            return "Nether";
        }
        if (dim.equals((Object)Level.f_46430_)) {
            return "End";
        }
        ResourceLocation loc = dim.m_135782_();
        if ("minecraft".equals(loc.m_135827_())) {
            return loc.m_135815_();
        }
        return loc.toString();
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent evt) {
        if (!(evt.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack stack = evt.getItem().m_32055_();
        if (stack == null || stack.m_41619_()) {
            return;
        }
        this.handleItemObtained(evt.getEntity(), stack.m_41720_());
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent evt) {
        if (!(evt.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack stack = evt.getCrafting();
        if (stack == null || stack.m_41619_()) {
            return;
        }
        this.handleItemObtained(evt.getEntity(), stack.m_41720_());
    }

    private void handleItemObtained(Player player, Item item) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Map map = (Map)REQUIRED.get();
        if (map.isEmpty()) {
            return;
        }
        ServerLevel overworld = sp.f_8924_.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        UnlockData data = UnlockData.get(overworld);
        boolean perPlayer = PER_PLAYER_UNLOCK_RUNTIME;
        boolean requireUntilVisited = REQUIRE_ITEM_UNTIL_VISITED_RUNTIME;
        String obtainedReg = null;
        try {
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (key != null) {
                obtainedReg = key.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry e : map.entrySet()) {
            boolean matches;
            String dimStr = (String)e.getKey();
            Requirement r = (Requirement)e.getValue();
            Item required = this.resolveItem(r.itemString());
            if (required != null) {
                matches = required == item;
            } else {
                boolean bl = matches = obtainedReg != null && obtainedReg.equals(r.itemString());
            }
            if (!matches) continue;
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)dimStr));
            if (requireUntilVisited && data.isUnlocked((ResourceKey<Level>)dimKey, sp.m_20148_(), perPlayer)) continue;
            String itemName = item.m_41466_().getString();
            String dimName = this.getFriendlyDimensionName((ResourceKey<Level>)dimKey);
            String rawGot = r.gotItemMessage();
            if (rawGot != null && !rawGot.isEmpty()) {
                String gotMsg = rawGot.replace("{dimension}", dimName).replace("{item}", itemName);
                sp.m_5661_((Component)Component.m_237113_((String)gotMsg), true);
            }
            if (!requireUntilVisited) continue;
            data.unlock((ResourceKey<Level>)dimKey, sp.m_20148_(), perPlayer);
        }
    }

    public record Requirement(String itemString, String blockMessage, String gotItemMessage, String dimString) {
    }

    public static class UnlockData
    extends SavedData {
        private final Map<UUID, Set<ResourceKey<Level>>> perPlayer = new HashMap<UUID, Set<ResourceKey<Level>>>();
        private final Set<ResourceKey<Level>> global = new HashSet<ResourceKey<Level>>();

        public static UnlockData get(ServerLevel level) {
            return (UnlockData)level.m_8895_().m_164861_(UnlockData::load, UnlockData::new, "portalrestrict_unlocks");
        }

        public static UnlockData load(CompoundTag tag) {
            UnlockData data = new UnlockData();
            ListTag gList = tag.m_128437_("globalDims", 8);
            for (int i = 0; i < gList.size(); ++i) {
                ResourceLocation loc = ResourceLocation.m_135820_((String)gList.m_128778_(i));
                if (loc == null) continue;
                data.global.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc));
            }
            CompoundTag players = tag.m_128469_("players");
            for (String key : players.m_128431_()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    ListTag list = players.m_128437_(key, 8);
                    HashSet<ResourceKey> set = new HashSet<ResourceKey>();
                    for (int i = 0; i < list.size(); ++i) {
                        ResourceLocation loc = ResourceLocation.m_135820_((String)list.m_128778_(i));
                        if (loc == null) continue;
                        set.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc));
                    }
                    data.perPlayer.put(uuid, set);
                }
                catch (Exception exception) {}
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            ListTag gList = new ListTag();
            for (ResourceKey<Level> k : this.global) {
                gList.add((Object)StringTag.m_129297_((String)k.m_135782_().toString()));
            }
            tag.m_128365_("globalDims", (Tag)gList);
            CompoundTag players = new CompoundTag();
            for (Map.Entry<UUID, Set<ResourceKey<Level>>> e : this.perPlayer.entrySet()) {
                ListTag list = new ListTag();
                for (ResourceKey<Level> k : e.getValue()) {
                    list.add((Object)StringTag.m_129297_((String)k.m_135782_().toString()));
                }
                players.m_128365_(e.getKey().toString(), (Tag)list);
            }
            tag.m_128365_("players", (Tag)players);
            return tag;
        }

        public boolean isUnlocked(ResourceKey<Level> dim, UUID uuid, boolean perPlayerUnlock) {
            return perPlayerUnlock ? this.perPlayer.getOrDefault(uuid, Collections.emptySet()).contains(dim) : this.global.contains(dim);
        }

        public void unlock(ResourceKey<Level> dim, UUID uuid, boolean perPlayerUnlock) {
            if (perPlayerUnlock) {
                this.perPlayer.computeIfAbsent(uuid, k -> new HashSet()).add(dim);
            } else {
                this.global.add(dim);
            }
            this.m_77762_();
        }
    }
}

