/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util.smart;

import com.dannyboythomas.hole_filler_mod.util.smart.SB;
import com.dannyboythomas.hole_filler_mod.util.smart.SimilarBlocks;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SimilarBlockPattern {
    HashMap<Block, Float> blocks = new HashMap();

    public SimilarBlockPattern(Vector<SB> sims) {
        for (int i = 0; i < sims.size(); ++i) {
            SB sb = sims.get(i);
            if (!this.ValidBlock(sb.block)) continue;
            this.blocks.put(sb.block, Float.valueOf(sb.value));
        }
    }

    public SimilarBlockPattern(SB ... sims) {
        for (int i = 0; i < sims.length; ++i) {
            SB sb = sims[i];
            if (!this.ValidBlock(sb.block)) continue;
            this.blocks.put(sb.block, Float.valueOf(sb.value));
        }
    }

    public Vector<Block> BlocksByPriority(Block block, boolean overridePriority) {
        Vector<Map.Entry<Block, Float>> list = new Vector<Map.Entry<Block, Float>>();
        for (Map.Entry<Block, Float> entry : this.blocks.entrySet()) {
            list.add(entry);
        }
        list.sort((a, b) -> {
            Float bValue = Float.valueOf(overridePriority ? 100.0f : ((Float)b.getValue()).floatValue());
            int dif = bValue.compareTo((Float)a.getValue());
            if (dif == 0) {
                dif = a.getKey() == block ? -1 : (b.getKey() == block ? 1 : 0);
            }
            return dif;
        });
        Vector<Block> sorted = new Vector<Block>();
        for (int i = 0; i < list.size(); ++i) {
            sorted.add((Block)((Map.Entry)list.get(i)).getKey());
        }
        return sorted;
    }

    public Vector<Block> Blocks() {
        Vector<Map.Entry> list = new Vector<Map.Entry>();
        for (Map.Entry<Block, Float> entry : this.blocks.entrySet()) {
            list.add(entry);
        }
        list.sort(Comparator.comparing(Map.Entry::getValue));
        Vector<Block> sorted = new Vector<Block>();
        for (int i = 0; i < list.size(); ++i) {
            sorted.add((Block)((Map.Entry)list.get(i)).getKey());
        }
        return sorted;
    }

    public boolean Contains(Block block) {
        return this.blocks.containsKey(block);
    }

    public boolean IsValidPattern() {
        return !this.blocks.isEmpty();
    }

    public boolean ValidBlock(Block block) {
        return block != null && !(block instanceof AirBlock) && block != Blocks.f_50752_ && !this.blocks.containsKey(block) && !SimilarBlocks.usedBlocks.contains(block);
    }

    public void Sort() {
    }
}

