/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.HoleFillerMod;
import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockVeinBreakable;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.util.ChunkHelper;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.smart.BlurredBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoleUtil {
    public static Block GetSmartFillBlock() {
        FillBlock type = (FillBlock)((Object)ConfigHoleFiller.smart_preserve_fill_block.get());
        if (type == FillBlock.cobblestone) {
            return Blocks.f_50652_;
        }
        if (type == FillBlock.stone) {
            return Blocks.f_50069_;
        }
        return Blocks.f_50493_;
    }

    public static boolean IsReplaceableBlock(Level world, BlockPos posi) {
        BlockState state = world.m_8055_(posi);
        Block block = state.m_60734_();
        return world.m_46859_(posi) || state.m_60722_((Fluid)null) && !(block instanceof BlockVeinBreakable) || block instanceof BlockLight;
    }

    public static boolean IsValidBoundaryBlock(Level world, BlockPos posi) {
        BlockState state = world.m_8055_(posi);
        Block block = state.m_60734_();
        boolean res = !world.m_46859_(posi) && Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)world, posi)) && state.m_60815_() && !(block instanceof LeavesBlock) && !HoleUtil.DoesMimicLog(state);
        boolean isHFM = block instanceof BlockHoleFillerBase || block instanceof BlockCuring;
        return res || isHFM;
    }

    public static boolean DoesMimicLog(BlockState state) {
        boolean isPillar = state.m_60734_() instanceof RotatedPillarBlock;
        boolean isBass = state.m_280603_() == NoteBlockInstrument.BASS;
        boolean isIgnited = state.m_278200_();
        boolean str2 = state.m_60734_().m_155943_() == 2.0f;
        return isPillar && isBass && isIgnited && str2;
    }

    public static boolean IsValidSelectableBlock(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        return Block.m_49916_((VoxelShape)state.m_60808_((BlockGetter)world, pos)) && state.m_60815_() && !(block instanceof EntityBlock);
    }

    public static Block GetSimilarBlockFast(Level world, Vec3i centre) {
        HashMap<Block, Float> blockScores = new HashMap<Block, Float>();
        Vec3i zero = new Vec3i(0, 0, 0);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Vec3i offset = new Vec3i(i, j, k);
                    if (offset == zero) continue;
                    int m = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    boolean isCorner = m == 3;
                    boolean isAdjacent = m == 1;
                    boolean isBelow = j == -1;
                    boolean isFlat = j == 0;
                    float multiplier = 0.0f;
                    multiplier += isFlat ? 13.1f : 0.0f;
                    multiplier += isAdjacent ? 6.1f : 0.0f;
                    multiplier += isCorner ? 1.0f : 0.0f;
                    float multi = multiplier += isBelow ? 1.2f : 0.0f;
                    Vec3i pos = H.Add(centre, offset);
                    BlockPos bPos = new BlockPos(pos);
                    BlockState state = world.m_8055_(bPos);
                    if (!HoleUtil.IsValidSelectableBlock(world, bPos)) continue;
                    Block block = state.m_60734_();
                    blockScores.computeIfPresent(block, (a, b) -> Float.valueOf(b.floatValue() + multi));
                    blockScores.putIfAbsent(block, Float.valueOf(multiplier));
                }
            }
        }
        Block targetBlock = Blocks.f_50493_;
        Map.Entry maxEntry = null;
        for (Map.Entry entry : blockScores.entrySet()) {
            if (maxEntry != null && ((Float)entry.getValue()).compareTo((Float)maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return maxEntry != null ? (Block)maxEntry.getKey() : targetBlock;
    }

    public static HashMap<Vec3i, Block> EstimateHoleBlockTypes(Level world, Vector<Vec3i> vecs, int kernelSize) {
        HashMap<Vec3i, BlurredBlock> blockMap = new HashMap<Vec3i, BlurredBlock>();
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            BlurredBlock newBlock = new BlurredBlock(vec);
            blockMap.put(vec, newBlock);
        }
        int passNum = 6;
        for (int n = 0; n < passNum; ++n) {
            for (Map.Entry entry : blockMap.entrySet()) {
                ((BlurredBlock)entry.getValue()).GetNewSurroundingsPopularity(world, kernelSize, blockMap, n);
            }
            for (Map.Entry entry : blockMap.entrySet()) {
                ((BlurredBlock)entry.getValue()).UpdateScores();
            }
        }
        HashMap<Vec3i, Block> blocksToPlace = new HashMap<Vec3i, Block>();
        for (Map.Entry entry : blockMap.entrySet()) {
            ((BlurredBlock)entry.getValue()).UpdateScores();
            blocksToPlace.put((Vec3i)entry.getKey(), ((BlurredBlock)entry.getValue()).Best());
        }
        return blocksToPlace;
    }

    public static boolean CanOverrideBlockTypePriority(Level world, Vec3i vec, Block block, HashMap<Vec3i, Block> volume) {
        if (block == Blocks.f_50440_) {
            BlockPos pos = new BlockPos(vec);
            Vec3i dir = new Vec3i(0, 1, 0);
            BlockPos check = pos.m_121955_(dir);
            boolean res = !volume.containsKey(check) && !HoleUtil.IsValidBoundaryBlock(world, check);
            return res;
        }
        return false;
    }

    public static boolean IsSurfaceBlock(Level world, Vec3i vec, HashMap<Vec3i, Block> volume) {
        Vector<Vec3i> neighs = H.GetNeighbourPositions(vec);
        int count = 0;
        for (int i = 0; i < neighs.size(); ++i) {
            BlockPos pos = new BlockPos(neighs.get(i));
            if (!HoleUtil.IsValidBoundaryBlock(world, pos) && !volume.containsKey(pos)) continue;
            ++count;
        }
        return count <= 5;
    }

    public static Vector<Vec3i> GetHole(Level world, Vec3i source, Player player) {
        int maxVolume;
        long start = System.nanoTime();
        HashMap<Vec3i, Boolean> foundCheckMap = new HashMap<Vec3i, Boolean>();
        Vector<Vec3i> found = new Vector<Vec3i>();
        found.add(source);
        Vector<Vec3i> volumeToCheck = (Vector<Vec3i>)found.clone();
        ArrayList<Vec3i> dirs = H.DirectionVectors;
        int foundCount = found.size();
        int maxLoop = 3000;
        int loop = 0;
        int n = maxVolume = HoleFillerMod.DEBUG_MODE ? 30000 : (Integer)ConfigHoleFiller.max_hole_volume.get();
        while (loop++ < maxLoop) {
            Vector<Vec3i> checkNext = new Vector<Vec3i>();
            for (int i = 0; i < volumeToCheck.size(); ++i) {
                Vec3i centre = (Vec3i)volumeToCheck.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vec3i dir = dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        Vec3i test = H.Add(centre, H.Multiply(dir, k));
                        if (!HoleUtil.IsValidHole(world, foundCheckMap, test, false, player) || foundCheckMap.getOrDefault(test, false).booleanValue()) continue;
                        foundCheckMap.put(test, true);
                        found.add(test);
                        checkNext.add(test);
                        if (found.size() < maxVolume) continue;
                        long endTime = System.nanoTime();
                        long time = endTime - start;
                        time /= 1000000L;
                        return found;
                    }
                }
            }
            if (foundCount == found.size()) break;
            volumeToCheck = checkNext;
        }
        long endTime = System.nanoTime();
        long time = endTime - start;
        time /= 1000000L;
        return found;
    }

    public static boolean IsValidHole(Level world, HashMap<Vec3i, Boolean> foundMap, Vec3i pos, boolean isLiquid, Player player) {
        int configMaxDiameter = isLiquid ? (Integer)ConfigHoleFiller.max_water_diameter.get() : (Integer)ConfigHoleFiller.max_hole_diameter.get();
        int maxDimension = configMaxDiameter / 2;
        int maxCount = 4;
        int count = 0;
        ArrayList<Vec3i> dirs = H.DirectionVectors;
        block0: for (int i = 0; i < dirs.size(); ++i) {
            Vec3i dir = dirs.get(i);
            for (int j = 1; j < maxDimension; ++j) {
                Vec3i spot = H.Add(pos, H.Multiply(dir, j));
                if (!HoleUtil.IsValidBoundaryBlock(world, new BlockPos(spot)) && !foundMap.getOrDefault(spot, false).booleanValue()) continue;
                ++count;
                continue block0;
            }
        }
        return count >= maxCount && HoleUtil.IsReplaceableBlock(world, new BlockPos(pos)) && ChunkHelper.CanChunkBeManipulated(pos, player);
    }

    public static Vector<Vec3i> GetHole(Level world, Vec3i source, Player player, Function<Vec3i, Boolean> accept) {
        int maxVolume;
        long start = System.nanoTime();
        HashMap<Vec3i, Boolean> foundCheckMap = new HashMap<Vec3i, Boolean>();
        Vector<Vec3i> found = new Vector<Vec3i>();
        found.add(source);
        Vector<Vec3i> volumeToCheck = (Vector<Vec3i>)found.clone();
        ArrayList<Vec3i> dirs = H.DirectionVectors;
        int foundCount = found.size();
        int maxLoop = 3000;
        int loop = 0;
        int n = maxVolume = HoleFillerMod.DEBUG_MODE ? 30000 : (Integer)ConfigHoleFiller.max_hole_volume.get();
        while (loop++ < maxLoop) {
            Vector<Vec3i> checkNext = new Vector<Vec3i>();
            for (int i = 0; i < volumeToCheck.size(); ++i) {
                Vec3i centre = (Vec3i)volumeToCheck.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vec3i dir = dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        Vec3i test = H.Add(centre, H.Multiply(dir, k));
                        if (!HoleUtil.IsValidHole(world, foundCheckMap, test, false, player) || foundCheckMap.getOrDefault(test, false).booleanValue() || !accept.apply(test).booleanValue()) continue;
                        foundCheckMap.put(test, true);
                        found.add(test);
                        checkNext.add(test);
                        if (found.size() < maxVolume) continue;
                        long endTime = System.nanoTime();
                        long time = endTime - start;
                        time /= 1000000L;
                        return found;
                    }
                }
            }
            if (foundCount == found.size()) break;
            volumeToCheck = checkNext;
        }
        long endTime = System.nanoTime();
        long time = endTime - start;
        time /= 1000000L;
        return found;
    }

    public static Vector<Vec3i> GetWaterHole(Level world, Vec3i source, Player player) {
        int maxVolume;
        long start = System.nanoTime();
        HashMap<Vec3i, Boolean> foundCheckMap = new HashMap<Vec3i, Boolean>();
        Vector<Vec3i> found = new Vector<Vec3i>();
        found.add(source);
        Vector<Vec3i> volumeToCheck = (Vector<Vec3i>)found.clone();
        ArrayList dirs = (ArrayList)H.DirectionVectors.clone();
        dirs.remove(dirs.size() - 1);
        int foundCount = found.size();
        int maxLoop = 3000;
        int loop = 0;
        int n = maxVolume = HoleFillerMod.DEBUG_MODE ? 30000 : (Integer)ConfigHoleFiller.max_water_volume.get();
        while (loop++ < maxLoop) {
            Vector<Vec3i> checkNext = new Vector<Vec3i>();
            for (int i = 0; i < volumeToCheck.size(); ++i) {
                Vec3i centre = (Vec3i)volumeToCheck.get(i);
                for (int j = 0; j < dirs.size(); ++j) {
                    Vec3i dir = (Vec3i)dirs.get(j);
                    for (int k = 1; k < 2; ++k) {
                        boolean isLava;
                        Vec3i test = H.Add(centre, H.Multiply(dir, k));
                        Block block = world.m_8055_(new BlockPos(test)).m_60734_();
                        boolean isWater = block == Blocks.f_49990_;
                        boolean bl = isLava = block == Blocks.f_49991_;
                        if (isLava || isWater || !HoleUtil.IsValidHole(world, foundCheckMap, test, true, player) || foundCheckMap.getOrDefault(test, false).booleanValue()) continue;
                        foundCheckMap.put(test, true);
                        found.add(test);
                        checkNext.add(test);
                        if (found.size() < maxVolume) continue;
                        long endTime = System.nanoTime();
                        long time = endTime - start;
                        time /= 1000000L;
                        return found;
                    }
                }
            }
            if (foundCount == found.size()) break;
            volumeToCheck = checkNext;
        }
        long endTime = System.nanoTime();
        long time = endTime - start;
        time /= 1000000L;
        return found;
    }

    public static Vector<Vec3i> GetLightPositions(Level world, Vec3i source, int minLightLevel, Player player) {
        Vector<Vec3i> placedLightPos = new Vector<Vec3i>();
        Vector<Vec3i> hole = HoleUtil.GetHole(world, source, player);
        for (int i = 0; i < hole.size(); ++i) {
            boolean worldIsBrightEnough;
            Vec3i vec = hole.get(i);
            BlockPos pos = new BlockPos(vec);
            if (!world.m_46859_(pos)) continue;
            int worldLight = world.m_45517_(LightLayer.BLOCK, pos);
            boolean bl = worldIsBrightEnough = worldLight >= minLightLevel;
            if (worldIsBrightEnough || HoleUtil.GetPotentialLightValue(placedLightPos, vec) >= minLightLevel) continue;
            placedLightPos.add(vec);
        }
        float p = (float)(placedLightPos.size() * 100) / (float)hole.size();
        return placedLightPos;
    }

    public static int GetPotentialLightValue(Vector<Vec3i> vecs, Vec3i pos) {
        int highest = 0;
        for (int i = 0; i < vecs.size(); ++i) {
            Vec3i vec = vecs.get(i);
            Vec3i offset = H.Subtract(vec, pos);
            int offsetMag = Math.abs(offset.m_123341_()) + Math.abs(offset.m_123342_()) + Math.abs(offset.m_123343_());
            int lightLevel = 15 - offsetMag;
            if (lightLevel <= highest) continue;
            highest = lightLevel;
        }
        return highest;
    }

    public static Vector<BlockPos> FloodFill(Level level, BlockPos start, Function<Block, Boolean> accept) {
        Vector<BlockPos> list = new Vector<BlockPos>();
        list.add(start);
        for (int index = 0; index < list.size(); ++index) {
            BlockPos currentPos = list.elementAt(index);
            for (int i = 0; i < H.DirectionVectors.size(); ++i) {
                Vec3i dir = H.DirectionVectors.get(i);
                BlockPos testPos = currentPos.m_121955_(dir);
                Block testBlock = level.m_8055_(testPos).m_60734_();
                boolean passed = accept.apply(testBlock);
                if (!passed || list.contains(testPos)) continue;
                list.add(testPos);
            }
        }
        return list;
    }

    public static boolean BlockIsOnAxis(Vec3i startVec, Vec3i vec, Vec3i normal) {
        Vec3i dif = vec.m_121996_(startVec);
        return HoleUtil.Dot(dif, normal) == 0;
    }

    public static int Dot(Vec3i start, Vec3i other) {
        return start.m_123341_() * other.m_123341_() + start.m_123342_() * other.m_123342_() + start.m_123343_() * other.m_123343_();
    }

    public static BlockPos BlockPosFromImpact(BlockHitResult result) {
        BlockPos bPos = result.m_82425_();
        Vec3i normal = result.m_82434_().m_122436_();
        BlockPos target = bPos.m_121955_(normal);
        return target;
    }

    public static enum FillBlock {
        cobblestone,
        dirt,
        stone;

    }

    public static enum FillerType {
        simple,
        balanced,
        smart,
        water,
        lava,
        light,
        dark,
        slice;

    }
}

