/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.blocks.BlockVeinBreakable;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.OrderByDistance;
import com.dannyboythomas.hole_filler_mod.util.OrderByHeight;
import com.dannyboythomas.hole_filler_mod.util.smart.CuringState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class HoleData {
    public Vec3i source;
    public Vector<Vec3i> preVolume;
    public HashMap<Vec3i, CuringState> filledVolume;
    public HashMap<Vec3i, Block> volume;
    public Vector<Vec3i> emptyVolume;

    public HoleData(Level world, Vec3i _source, HoleUtil.FillerType fillerType, boolean gravity, Player player) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        if (fillerType == HoleUtil.FillerType.water || fillerType == HoleUtil.FillerType.lava) {
            this.preVolume = HoleUtil.GetWaterHole(world, this.source, player);
        } else if (fillerType == HoleUtil.FillerType.dark) {
            this.preVolume = HoleUtil.GetHole(world, this.source, player);
            this.preVolume = this.preVolume.stream().filter(vec -> {
                BlockPos pos = new BlockPos(vec);
                Block block = world.m_8055_(pos).m_60734_();
                return block instanceof BlockLight || block instanceof BlockHoleFillerLight;
            }).collect(Collectors.toCollection(() -> new Vector()));
        } else {
            this.preVolume = HoleUtil.GetHole(world, this.source, player);
            this.ApplyBlockTypesToPositions(world, fillerType);
            this.Order(gravity);
        }
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public HoleData(Level world, Vec3i _source, int minLightLevel, Player player) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        this.preVolume = HoleUtil.GetLightPositions(world, this.source, minLightLevel, player);
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public HoleData(Vec3i _source) {
        this.source = _source;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public HoleData(Level world, BlockHitResult hitResult, HoleUtil.FillerType fillerType, Player player) {
        BlockPos pos = hitResult.m_82425_().m_121955_(hitResult.m_82434_().m_122436_());
        this.source = pos;
        this.preVolume = new Vector();
        this.volume = new HashMap();
        if (fillerType == HoleUtil.FillerType.slice) {
            this.preVolume = HoleUtil.GetHole(world, this.source, player, v -> HoleUtil.BlockIsOnAxis(this.source, v, hitResult.m_82434_().m_122436_()));
        }
        this.filledVolume = new HashMap();
        this.emptyVolume = this.preVolume;
        this.emptyVolume.remove(this.source);
    }

    public void Order(boolean gravity) {
        if (gravity) {
            this.preVolume.sort(new OrderByHeight(H.Vec3d(this.source)));
        } else {
            this.preVolume.sort(new OrderByDistance(H.Vec3d(this.source)));
        }
    }

    public void ApplyBlockTypesToPositions(Level world, HoleUtil.FillerType fillerType) {
        if (fillerType == HoleUtil.FillerType.smart) {
            this.volume = HoleUtil.EstimateHoleBlockTypes(world, this.preVolume, 5);
        }
    }

    public boolean TickCuringStates(Level world, Player player) {
        int seconds = (Integer)ConfigHoleFiller.undo_timer.get();
        int ticks = seconds * 20;
        float incr = 1.0f / (float)ticks;
        Vector<Vec3i> toRemove = new Vector<Vec3i>();
        boolean markForRemoval = false;
        for (Map.Entry<Vec3i, CuringState> entry : this.filledVolume.entrySet()) {
            CuringState state = entry.getValue();
            float progressBefore = state.progress;
            float p = state.IncreaseProgress(incr);
            if (p == 1.0f && progressBefore != p && world.m_8055_(new BlockPos(state.pos)).m_60734_() instanceof BlockVeinBreakable) {
                HoleData.spawnParticles(world, new BlockPos(state.pos));
                world.m_46597_(new BlockPos(state.pos), state.block.m_49966_());
                toRemove.add(entry.getKey());
                continue;
            }
            if (world.m_8055_(new BlockPos(state.pos)).m_60734_() instanceof BlockVeinBreakable) continue;
            markForRemoval = true;
            toRemove.add(entry.getKey());
            if (player.m_150110_().f_35937_) continue;
            Vec3 dropPos = player != null ? player.m_20182_() : H.Vec3d(state.pos);
            ItemEntity drop = new ItemEntity(world, dropPos.m_7096_(), dropPos.m_7098_(), dropPos.m_7094_(), new ItemStack((ItemLike)state.block.m_5456_(), 1));
            world.m_7967_((Entity)drop);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.filledVolume.remove(toRemove.get(i));
        }
        return this.filledVolume.size() == 0 || markForRemoval;
    }

    private static void spawnParticles(Level world, BlockPos blockPos) {
        double d0 = 0.5625;
        RandomSource random = world.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.m_121945_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)blockPos.m_123341_() + d1, (double)blockPos.m_123342_() + d2, (double)blockPos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag Write(CompoundTag nbt) {
        void var5_8;
        ArrayList<Integer> volumeList = new ArrayList<Integer>();
        for (int i = 0; i < this.preVolume.size(); ++i) {
            Vec3i vec = this.preVolume.get(i);
            volumeList.add(vec.m_123341_());
            volumeList.add(vec.m_123342_());
            volumeList.add(vec.m_123343_());
        }
        ListTag filledList = new ListTag();
        for (Map.Entry entry : this.filledVolume.entrySet()) {
            CuringState curingState = (CuringState)entry.getValue();
            CompoundTag stateNBT = curingState.Write();
            filledList.add((Object)stateNBT);
        }
        ArrayList<Integer> emptyList = new ArrayList<Integer>();
        boolean bl = false;
        while (var5_8 < this.emptyVolume.size()) {
            Vec3i vec = this.emptyVolume.get((int)var5_8);
            emptyList.add(vec.m_123341_());
            emptyList.add(vec.m_123342_());
            emptyList.add(vec.m_123343_());
            ++var5_8;
        }
        nbt.m_128408_("volume_list", volumeList);
        nbt.m_128365_("filled_list", (Tag)filledList);
        nbt.m_128408_("empty_list", emptyList);
        ListTag listTag = new ListTag();
        for (Map.Entry<Vec3i, Block> entry : this.volume.entrySet()) {
            if (entry.getValue() == null) continue;
            CompoundTag listItem = new CompoundTag();
            listItem.m_128385_("pos", H.ToArray(entry.getKey()));
            listItem.m_128359_("block_name", H.GetRegistryName(entry.getValue()));
            listTag.add((Object)listItem);
        }
        nbt.m_128365_("block_list", (Tag)listTag);
        return nbt;
    }

    public static HoleData Read(BlockState state, CompoundTag nbt, Vec3i pos) {
        int i;
        HoleData data = new HoleData(pos);
        int[] volumeArray = nbt.m_128465_("volume_list");
        data.preVolume = new Vector();
        if (volumeArray != null) {
            int posCount = volumeArray.length / 3;
            for (i = 0; i < posCount; ++i) {
                int o = i * 3;
                Vec3i newVec = new Vec3i(volumeArray[o], volumeArray[o + 1], volumeArray[o + 2]);
                data.preVolume.add(newVec);
            }
        }
        ListTag filledArray = nbt.m_128437_("filled_list", 10);
        data.filledVolume = new HashMap();
        if (filledArray != null) {
            for (i = 0; i < filledArray.size(); ++i) {
                CompoundTag tag = filledArray.m_128728_(i);
                CuringState curingState = new CuringState(tag);
                data.filledVolume.put(curingState.pos, curingState);
            }
        }
        int[] emptyArray = nbt.m_128465_("empty_list");
        data.emptyVolume = new Vector();
        if (emptyArray != null) {
            int posCount = emptyArray.length / 3;
            for (int i2 = 0; i2 < posCount; ++i2) {
                int o = i2 * 3;
                Vec3i newVec = new Vec3i(emptyArray[o], emptyArray[o + 1], emptyArray[o + 2]);
                data.emptyVolume.add(newVec);
            }
        }
        data.volume = new HashMap();
        ListTag allBlocks = nbt.m_128437_("block_list", 10);
        for (int i3 = 0; i3 < allBlocks.size(); ++i3) {
            CompoundTag listItem = allBlocks.m_128728_(i3);
            BlockPos v = H.Convert(listItem.m_128465_("pos"));
            String blockName = listItem.m_128461_("block_name");
            ResourceLocation res = new ResourceLocation(blockName);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
            data.volume.put((Vec3i)v, block);
        }
        return data;
    }
}

