/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.init.ModTiles;
import com.dannyboythomas.hole_filler_mod.tiles.TileHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import com.dannyboythomas.hole_filler_mod.util.smart.CuringState;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileHoleFillerSmart
extends TileHoleFillerBase {
    public TileHoleFillerSmart(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.HOLE_FILLER_SMART.get(), pos, state);
    }

    @Override
    HoleUtil.FillerType GetFillerType() {
        return HoleUtil.FillerType.smart;
    }

    @Override
    public Block GetBlockToPlace(Vec3i vec) {
        Block potential;
        if (this.holedata != null && this.holedata.volume != null && (potential = this.holedata.volume.get(vec)) != null) {
            return potential;
        }
        return super.GetBlockToPlace(vec);
    }

    @Override
    public void Start() {
        if (this.thrower == null) {
            return;
        }
        Inventory inv = this.thrower.m_150109_();
        if (inv == null && !this.creativeMode) {
            if (((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50493_.m_49966_());
            }
            return;
        }
        this.thrower.m_5661_((Component)Component.m_237113_((String)"Calculating...."), true);
        this.holedata = new HoleData(this.f_58857_, (Vec3i)this.f_58858_, this.GetFillerType(), false, this.thrower);
        this.thrower.m_5661_((Component)Component.m_237113_((String)" "), true);
        Block thisBlockWillBe = this.GetBlockToTakeAndFillWith((Vec3i)this.f_58858_, (Container)inv);
        if (thisBlockWillBe != null && (IH.HasStack((Container)inv, H.Single(thisBlockWillBe), true) || this.creativeMode)) {
            if (IH.Take((Container)inv, H.Single(thisBlockWillBe), this.creativeMode, true)) {
                this.holedata.volume.put((Vec3i)this.f_58858_, thisBlockWillBe);
                this.running = true;
            }
            this.LogThrow();
        } else {
            this.holedata = null;
            if (!this.thrower.m_150110_().f_35937_) {
                ItemEntity entity = new ItemEntity(this.f_58857_, this.thrower.m_20185_(), this.thrower.m_20186_(), this.thrower.m_20189_(), new ItemStack((ItemLike)this.GetThrowableItem(), 1));
                this.f_58857_.m_7967_((Entity)entity);
            }
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            this.EndPlacement("Missing Resources");
        }
    }

    Block GetBlockToTakeAndFillWith(Vec3i vec, Container inv) {
        Block possibleBlock = this.GetBlockToPlace(vec);
        if (this.creativeMode) {
            return possibleBlock;
        }
        boolean canOverride = HoleUtil.CanOverrideBlockTypePriority(this.f_58857_, vec, possibleBlock, this.holedata.volume);
        Block targetBlock = IH.TryTakeSimilarBlock(this.creativeMode, possibleBlock, inv, false, canOverride);
        if (((Boolean)ConfigHoleFiller.smart_preserve.get()).booleanValue() && !HoleUtil.IsSurfaceBlock(this.f_58857_, vec, this.holedata.volume)) {
            targetBlock = this.FailSafeBlock();
        }
        if (targetBlock == null) {
            return possibleBlock;
        }
        return targetBlock;
    }

    public Block FailSafeBlock() {
        if (((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue()) {
            return Blocks.f_50493_;
        }
        return HoleUtil.GetSmartFillBlock();
    }

    @Override
    public boolean TakeAndPlace(Container inv, Block block) {
        if (block == null) {
            return false;
        }
        Vec3i vec = this.holedata.emptyVolume.firstElement();
        if (this.creativeMode) {
            this.holedata.emptyVolume.remove(0);
            if (HoleUtil.IsReplaceableBlock(this.f_58857_, new BlockPos(vec))) {
                this.holedata.filledVolume.put(vec, new CuringState(vec, block));
                this.f_58857_.m_46597_(new BlockPos(vec), ((BlockCuring)((Object)ModBlocks.curing_block.get())).m_49966_());
            }
            return true;
        }
        Block possibleBlock = this.GetBlockToPlace(vec);
        boolean canOverride = HoleUtil.CanOverrideBlockTypePriority(this.f_58857_, vec, possibleBlock, this.holedata.volume);
        Block targetBlock = this.GetBlockToTakeAndFillWith(vec, inv);
        this.holedata.volume.put(vec, targetBlock);
        if (targetBlock != null && inv != null && IH.HasStack(inv, H.Single(targetBlock), true)) {
            this.holedata.emptyVolume.remove(0);
            if (HoleUtil.IsReplaceableBlock(this.f_58857_, new BlockPos(vec)) && IH.Take(inv, H.Single(targetBlock), this.creativeMode, true)) {
                this.holedata.filledVolume.put(vec, new CuringState(vec, targetBlock));
                this.f_58857_.m_46597_(new BlockPos(vec), ((BlockCuring)((Object)ModBlocks.curing_block.get())).m_49966_());
                return true;
            }
        }
        return false;
    }

    @Override
    public void DropInventory(Player player, boolean includeSelf) {
        if (this.creativeMode || player.m_150110_().f_35937_ || this.holedata == null) {
            return;
        }
        int count = this.holedata.filledVolume.size();
        for (Map.Entry<Vec3i, CuringState> entry : this.holedata.filledVolume.entrySet()) {
            Block block = entry.getValue().block;
            H.Drop(this.f_58857_, this.creativeMode, block, player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
        if (includeSelf) {
            H.Drop(this.f_58857_, this.creativeMode, this.GetBlockToPlace((Vec3i)this.f_58858_), player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }
}

