/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.items;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.data.HFMSavedData;
import com.dannyboythomas.hole_filler_mod.entities.EntityThrowableHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.entities.EntityThrowableHoleFillerSimple;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemThrowableHoleFiller
extends Item {
    public ItemThrowableHoleFiller(Item.Properties properties) {
        super(properties);
    }

    public String Color() {
        return "\u00a7a ";
    }

    public boolean CanSelectBlock() {
        return false;
    }

    public EntityThrowableHoleFillerBase GetThrowableEntity(Player player, Level world) {
        return new EntityThrowableHoleFillerSimple((LivingEntity)player, world);
    }

    boolean CanThrow(Player player, ItemStack stack) {
        ItemStack blockStack = new ItemStack((ItemLike)Blocks.f_50493_, 1);
        return player.m_150110_().f_35937_ || (Boolean)ConfigHoleFiller.is_dirt_free.get() != false || IH.HasStack((Container)player.m_150109_(), blockStack, true);
    }

    boolean HasPermission(Player player) {
        boolean requiresPermission = (Boolean)ConfigHoleFiller.restricted_use.get();
        boolean passesPermission = requiresPermission && player.m_20310_(2);
        return !requiresPermission || passesPermission;
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        if (!this.CanSelectBlock()) {
            return InteractionResult.PASS;
        }
        Player player = useContext.m_43723_();
        Level world = useContext.m_43725_();
        if (!world.f_46443_ && player != null && player.m_6144_()) {
            BlockPos pos = useContext.m_8083_();
            BlockState state = useContext.m_43725_().m_8055_(pos);
            boolean validBlock = HoleUtil.IsValidSelectableBlock(world, pos);
            if (validBlock) {
                String regName = H.GetRegistryName(state.m_60734_());
                useContext.m_43722_().m_41784_().m_128359_("block_name", regName);
                ItemStack stack = state.getCloneItemStack(null, (BlockGetter)world, pos, null);
                player.m_5661_((Component)Component.m_237113_((String)("Fill with:" + this.Color() + stack.m_41786_().getString())), true);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76Invalid Block"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack stack = playerEntity.m_21120_(hand);
        Random random = new Random();
        world.m_6263_((Player)null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.15f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        if (!world.f_46443_ && !playerEntity.m_6144_()) {
            HFMSavedData data = (HFMSavedData)playerEntity.m_20194_().m_129783_().m_8895_().m_164861_(HFMSavedData::Load, HFMSavedData::Create, "hole_filler_mod");
            ItemStack single = stack.m_41777_();
            single.m_41764_(1);
            if (this.CanThrow(playerEntity, single) && this.HasPermission(playerEntity)) {
                UUID playerID = playerEntity.m_36316_().getId();
                single.m_41784_().m_128359_("thrower", playerID.toString());
                single.m_41784_().m_128379_("creative", playerEntity.m_150110_().f_35937_);
                EntityThrowableHoleFillerBase ent = this.GetThrowableEntity(playerEntity, world);
                ent.m_37446_(single);
                ent.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 1.0f);
                world.m_7967_((Entity)ent);
                stack.m_41774_(1);
            } else {
                String msg = this.HasPermission(playerEntity) ? "Missing Resources" : "No Permission";
                playerEntity.m_5661_((Component)Component.m_237113_((String)msg), true);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public List<Component> ExtraInfo() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237113_((String)("Free Dirt:" + this.Color() + ConfigHoleFiller.is_dirt_free.get())));
        return tooltip;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96639_()) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77A hole filled with 'Curing Blocks', can be undone within").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.undo_timer.get()))).m_7220_((Component)Component.m_237113_((String)" \u00a77seconds by breaking any Curing Block")));
            tooltip.add((Component)Component.m_237113_((String)"   "));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Ctrl + Alt to preview."));
        } else if (Screen.m_96638_()) {
            if (this.CanSelectBlock()) {
                String blockName = stack.m_41784_().m_128461_("block_name");
                if (blockName == null || blockName.isEmpty()) {
                    blockName = "minecraft:dirt";
                }
                ResourceLocation res = new ResourceLocation(blockName);
                Block blockToPlace = ((Block)ForgeRegistries.BLOCKS.getValue(res)).m_49966_().m_60734_();
                ItemStack blockStack = new ItemStack((ItemLike)blockToPlace.m_5456_(), 1);
                tooltip.add((Component)Component.m_237113_((String)("Block:" + this.Color() + blockStack.m_41786_().getString())));
                tooltip.add((Component)Component.m_237113_((String)"\u00a77Right click block to change"));
            }
            tooltip.add((Component)Component.m_237113_((String)"Diameter:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.max_hole_diameter.get()))).m_7220_((Component)Component.m_237113_((String)" blocks")));
            tooltip.add((Component)Component.m_237113_((String)"Fill:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.max_hole_volume.get()))).m_7220_((Component)Component.m_237113_((String)" blocks")));
            tooltip.add((Component)Component.m_237113_((String)"Speed:").m_7220_((Component)Component.m_237113_((String)(this.Color() + (Integer)ConfigHoleFiller.fill_speed.get() * 20))).m_7220_((Component)Component.m_237113_((String)" blocks/second")));
            tooltip.add((Component)Component.m_237113_((String)"Timer:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.undo_timer.get()))).m_7220_((Component)Component.m_237113_((String)" seconds")));
            tooltip.addAll(this.ExtraInfo());
            tooltip.add((Component)Component.m_237113_((String)"   "));
            tooltip.add((Component)Component.m_237113_((String)("Restricted:" + this.Color() + ConfigHoleFiller.restricted_use.get())));
        } else {
            tooltip.add((Component)Component.m_237113_((String)("Hold" + this.Color() + "'Shift'\u00a7r for info.")));
            tooltip.add((Component)Component.m_237113_((String)"Hold\u00a77 'Alt'\u00a7r for shared info."));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

