/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.config;

import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHoleFiller {
    public static ForgeConfigSpec.IntValue max_hole_diameter;
    public static ForgeConfigSpec.IntValue max_hole_volume;
    public static ForgeConfigSpec.IntValue undo_timer;
    public static ForgeConfigSpec.IntValue fill_speed;
    public static ForgeConfigSpec.BooleanValue is_dirt_free;
    public static ForgeConfigSpec.BooleanValue smart_preserve;
    public static ForgeConfigSpec.EnumValue smart_preserve_fill_block;
    public static ForgeConfigSpec.IntValue max_water_diameter;
    public static ForgeConfigSpec.IntValue max_water_volume;
    public static ForgeConfigSpec.IntValue torch_places_n_light_sources;
    public static ForgeConfigSpec.DoubleValue torch_return_rate;
    public static ForgeConfigSpec.BooleanValue restricted_use;

    public static void Init(ForgeConfigSpec.Builder server) {
        server.comment("Hole Filler Config");
        max_hole_diameter = server.comment("Maximum diameter that the hole filler will consider a hole. If hole is larger than this value, it will not fill on that axis.  Default = 12").defineInRange("hole_filler.max_hole_diameter", 12, 3, 32);
        max_hole_volume = server.comment("Maximum number of blocks that can be placed per hole. Default = 500").defineInRange("hole_filler.max_hole_volume", 500, 1, 5000);
        undo_timer = server.comment("How long before 'Curing Blocks' are converted to dirt, in seconds. This is an approximation as some randomness is involved. Default = 15").defineInRange("hole_filler.undo_timer", 15, 1, 120);
        fill_speed = server.comment("How many 'Curing Blocks' placed per tick. Default = 5").defineInRange("hole_filler.fill_speed", 5, 1, 120);
        is_dirt_free = server.comment("If true, dirt isn't required in the player's inventory").define("hole_filler.is_dirt_free", true);
        smart_preserve = server.comment("If true, will fill majority of hole with dirt, leaving only surface blocks to match the environment").comment("Recommended to set 'is_dirt_free' to true").define("hole_filler.smart_preserve", false);
        smart_preserve_fill_block = server.comment("The block the smart_preserve uses from your inventory").comment("This is ignored if 'is_dirt_free' is true").defineEnum("hole_filler.smart_preserve_fill_block", (Enum)HoleUtil.FillBlock.cobblestone, (Enum[])HoleUtil.FillBlock.values());
        max_water_diameter = server.comment("Maximum diameter that the hole filler will consider a hole. If hole is larger than this value, it will not fill on that axis.  Default = 18").defineInRange("hole_filler.max_water_diameter", 18, 3, 32);
        max_water_volume = server.comment("Maximum number of blocks that can be placed per hole. Default = 500").defineInRange("hole_filler.max_water_volume", 500, 1, 5000);
        restricted_use = server.comment("If true, only players with OP permission can use").define("hole_filler.restricted_use", false);
        torch_places_n_light_sources = server.comment("How many light sources can the Light Hole Filler place per torch in the players inventory.  Default = 6").defineInRange("hole_filler.torch_places_n_light_sources", 6, 1, 128);
        torch_return_rate = server.comment("What percentage of the light sources placed by the Light Hole Filler will the player get back.  Default = 70%").defineInRange("hole_filler.torch_return_rate", 0.7, 0.0, 1.0);
    }
}

