/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.wall.Walls;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CompactStructureGenerator {
    public static AABB getWallBounds(Vec3i size, BlockPos cubeFloor, Direction wall) {
        switch (wall) {
            case NORTH: 
            case SOUTH: {
                int offsetNorthSouth = (int)Math.ceil((float)size.m_123343_() / 2.0f);
                BlockPos start = cubeFloor.m_5484_(wall, offsetNorthSouth);
                return new AABB(start, start).m_82363_(0.0, (double)size.m_123342_(), 0.0).m_82377_(Math.ceil((float)size.m_123341_() / 2.0f), 0.0, 0.0);
            }
            case WEST: 
            case EAST: {
                int offsetWestEast = (int)Math.ceil((float)size.m_123341_() / 2.0f);
                BlockPos start = cubeFloor.m_5484_(wall, offsetWestEast);
                return new AABB(start, start).m_82363_(0.0, (double)size.m_123342_(), 0.0).m_82377_(0.0, 0.0, Math.ceil((float)size.m_123343_() / 2.0f));
            }
            case UP: 
            case DOWN: {
                BlockPos start = wall == Direction.DOWN ? cubeFloor : cubeFloor.m_5484_(wall, size.m_123342_());
                AABB aabb = new AABB(start, start).m_82377_(Math.ceil((float)size.m_123341_() / 2.0f), 0.0, Math.ceil((float)size.m_123343_() / 2.0f));
                if (wall == Direction.UP) {
                    aabb = aabb.m_82377_(0.0, 1.0, 0.0);
                }
                return aabb;
            }
        }
        return AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0);
    }

    public static void generateCompactWall(LevelAccessor world, Vec3i dimensions, BlockPos cubeCenter, Direction wallDirection) {
        BlockState unbreakableWall = ((Block)Walls.BLOCK_SOLID_WALL.get()).m_49966_();
        AABB wallBounds = CompactStructureGenerator.getWallBounds(dimensions, cubeCenter, wallDirection);
        BlockPos.m_121921_((AABB)wallBounds).map(BlockPos::m_7949_).forEach(p -> world.m_7731_(p, unbreakableWall, 7));
    }

    @Deprecated(forRemoval=true)
    public static void generateCompactWall(LevelAccessor world, RoomSize size, BlockPos cubeFloor, Direction wallDirection) {
        BlockState unbreakableWall = ((Block)Walls.BLOCK_SOLID_WALL.get()).m_49966_();
        AABB wallBounds = CompactStructureGenerator.getWallBounds(size.toVec3(), cubeFloor, wallDirection);
        BlockPos.m_121921_((AABB)wallBounds).filter(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0)).map(BlockPos::m_7949_).forEach(p -> world.m_7731_(p, unbreakableWall, 7));
    }

    public static void generateCompactStructure(LevelAccessor world, Vec3i dimensions, BlockPos cubeFloorCenter) {
        AABB floorBlocks = CompactStructureGenerator.getWallBounds(dimensions, cubeFloorCenter, Direction.DOWN);
        AABB machineInternal = floorBlocks.m_82386_(1.0, 1.0, 1.0).m_82310_(2.0, 0.0, 2.0).m_82363_(0.0, (double)(dimensions.m_123342_() - 1), 0.0);
        boolean anyAir = BlockPos.m_121921_((AABB)floorBlocks).anyMatch(arg_0 -> ((LevelAccessor)world).m_46859_(arg_0));
        if (anyAir) {
            for (Direction dir : Direction.values()) {
                CompactStructureGenerator.generateCompactWall(world, dimensions, cubeFloorCenter, dir);
            }
            BlockPos.m_121921_((AABB)machineInternal).forEach(p -> world.m_7731_(p, Blocks.f_50016_.m_49966_(), 7));
        }
    }

    public static BlockPos cornerFromSize(Vec3i dimensions, BlockPos cubeFloorCenter) {
        Vec3i offset = new Vec3i(-Mth.m_14143_((float)((float)dimensions.m_123341_() / 2.0f)), 1, -Mth.m_14143_((float)((float)dimensions.m_123343_() / 2.0f)));
        return cubeFloorCenter.m_121955_(offset);
    }
}

