/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.core.Registries;
import dev.compactmods.machines.tunnel.TunnelItem;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.definitions.FluidTunnel;
import dev.compactmods.machines.tunnel.definitions.ForgeEnergyTunnel;
import dev.compactmods.machines.tunnel.definitions.ItemTunnel;
import dev.compactmods.machines.tunnel.definitions.UnknownTunnel;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Tunnels {
    public static final Supplier<IForgeRegistry<TunnelDefinition>> TUNNEL_DEF_REGISTRY = Registries.TUNNEL_DEFINITIONS.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<TunnelDefinition> UNKNOWN = Registries.TUNNEL_DEFINITIONS.register("unknown", UnknownTunnel::new);
    public static final RegistryObject<Item> ITEM_TUNNEL = Registries.ITEMS.register("tunnel", () -> new TunnelItem(new Item.Properties()));
    public static final RegistryObject<TunnelDefinition> ITEM_TUNNEL_DEF = Registries.TUNNEL_DEFINITIONS.register("item", ItemTunnel::new);
    public static final RegistryObject<TunnelDefinition> FLUID_TUNNEL_DEF = Registries.TUNNEL_DEFINITIONS.register("fluid", FluidTunnel::new);
    public static final RegistryObject<TunnelDefinition> FORGE_ENERGY = Registries.TUNNEL_DEFINITIONS.register("energy", ForgeEnergyTunnel::new);
    public static final RegistryObject<Block> BLOCK_TUNNEL_WALL = Registries.BLOCKS.register("tunnel_wall", () -> new TunnelWallBlock(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 3600000.8f).m_60918_(SoundType.f_56743_).m_60953_(state -> 15)));
    public static final RegistryObject<BlockEntityType<TunnelWallEntity>> TUNNEL_BLOCK_ENTITY = Registries.BLOCK_ENTITIES.register("tunnel_wall", () -> BlockEntityType.Builder.m_155273_(TunnelWallEntity::new, (Block[])new Block[]{(Block)BLOCK_TUNNEL_WALL.get()}).m_58966_(null));

    public static boolean isRegistered(ResourceLocation id) {
        return TUNNEL_DEF_REGISTRY.get().containsKey(id);
    }

    public static TunnelDefinition getDefinition(ResourceLocation id) {
        if (Tunnels.isRegistered(id)) {
            return (TunnelDefinition)TUNNEL_DEF_REGISTRY.get().getValue(id);
        }
        CompactMachines.LOGGER.warn("Unknown tunnel requested: {}", (Object)id);
        return (TunnelDefinition)UNKNOWN.get();
    }

    public static ResourceLocation getRegistryId(TunnelDefinition definition) {
        IForgeRegistry<TunnelDefinition> reg = TUNNEL_DEF_REGISTRY.get();
        if (!reg.containsValue((Object)definition)) {
            return new ResourceLocation("compactmachines", "unknown");
        }
        return reg.getKey((Object)definition);
    }

    public static void prepare() {
    }
}

