/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class TunnelHelper {
    private static final TicketType<ChunkPos> CM4_TUUNEL_LOAD_TYPE = TicketType.m_9462_((String)"compactmachines:tunnels", Comparator.comparingLong(ChunkPos::m_45588_));

    @Nonnull
    public static Direction getNextDirection(Direction in) {
        return switch (in) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.NORTH;
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.UP;
        };
    }

    public static Stream<Direction> getOrderedSides() {
        return Stream.of(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    }

    public static Optional<Direction> getNextDirection(Direction current, Set<Direction> used) {
        List<Direction> ordered = TunnelHelper.getOrderedSides().toList();
        int found = ordered.indexOf(current);
        Stream stream = Stream.generate(() -> ordered).flatMap(Collection::stream);
        return stream.skip(found + 1).filter(dir -> !used.contains(dir)).findFirst();
    }

    public static void setChunkMode(ServerLevel level, ChunkPos room, boolean forceLoad) {
        ServerChunkCache chunks = level.m_7726_();
        level.m_8602_(room.f_45578_, room.f_45579_, forceLoad);
        if (forceLoad) {
            chunks.m_8387_(CM4_TUUNEL_LOAD_TYPE, room, 2, (Object)room);
        } else {
            chunks.m_8438_(CM4_TUUNEL_LOAD_TYPE, room, 2, (Object)room);
        }
        chunks.m_8419_(true);
    }
}

