/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.network;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkEvent;

public record PlayerRequestedTeleportPacket(GlobalPos machine, ChunkPos room) {
    public PlayerRequestedTeleportPacket(FriendlyByteBuf buf) {
        this((GlobalPos)buf.m_271872_(GlobalPos.f_122633_), buf.m_178383_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_272073_(GlobalPos.f_122633_, (Object)this.machine);
        buf.m_178341_(this.room);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            try {
                PlayerUtil.teleportPlayerIntoMachine(player.m_9236_(), (Player)player, this.machine.m_122646_());
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.error("Failed to teleport player into machine.", (Throwable)e);
            }
        });
        return true;
    }
}

