/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.client;

import dev.compactmods.gander.level.VirtualLevel;
import dev.compactmods.gander.render.baked.BakedLevel;
import dev.compactmods.gander.ui.widget.SpatialRenderer;
import dev.compactmods.machines.client.gui.widget.PSDIconButton;
import dev.compactmods.machines.shrinking.Shrinking;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class MachineRoomScreen
extends Screen {
    private final GlobalPos machinePos;
    private final ChunkPos room;
    protected double rotateX = 45.0;
    protected double rotateY = 20.0;
    private PSDIconButton psdButton;
    private BakedLevel scene;
    private SpatialRenderer renderer;
    private Component sceneSource;

    public MachineRoomScreen(Component title, GlobalPos machinePos, ChunkPos room) {
        super(title);
        this.machinePos = machinePos;
        this.room = room;
    }

    protected void m_7856_() {
        super.m_7856_();
        int guiWidth = 260;
        int guiHeight = 240;
        int left = this.f_96543_ / 2 - 130;
        int top = this.f_96544_ / 2 - 120;
        this.renderer = (SpatialRenderer)this.m_142416_((GuiEventListener)new SpatialRenderer(left, top, 260, 240));
        this.psdButton = (PSDIconButton)this.m_142416_((GuiEventListener)new PSDIconButton(this.machinePos, this.room, left + 220, top + 210));
        if (this.hasPsdItem()) {
            this.psdButton.setEnabled(true);
        }
        this.updateSceneRenderers();
    }

    private void updateSceneRenderers() {
        if (this.scene != null) {
            this.renderer.setData(this.scene);
            this.renderer.camera().zoom(MachineRoomScreen.calculateZoomForRoom(AABB.m_82321_((BoundingBox)this.scene.blockBoundaries())));
        }
    }

    private static float calculateZoomForRoom(AABB internalSize) {
        double maxSize = Math.max(internalSize.m_82362_(), internalSize.m_82385_());
        return (float)(-1.0 * maxSize) - 3.0f;
    }

    private boolean hasPsdItem() {
        return this.f_96541_.f_91074_.m_150109_().m_36063_(new ItemStack((ItemLike)Shrinking.PERSONAL_SHRINKING_DEVICE.get()));
    }

    public void m_86600_() {
        Object t;
        super.m_86600_();
        if (this.scene != null && (t = this.scene.originalLevel().get()) instanceof VirtualLevel) {
            VirtualLevel vl = (VirtualLevel)t;
            vl.tick(this.f_96541_.getPartialTick());
            vl.animateTick();
        }
        if (this.psdButton != null) {
            this.psdButton.setEnabled(this.f_96541_.f_91074_.m_7500_() || this.hasPsdItem());
        }
    }

    public boolean m_7979_(double mx, double my, int mButton, double dx, double dy) {
        boolean s = super.m_7979_(mx, my, mButton, dx, dy);
        if (!s) {
            return false;
        }
        this.rotateX += dx;
        this.rotateY += dy;
        return true;
    }

    public boolean m_7933_(int code, int scanCode, int modifiers) {
        float rotateSpeed = 0.083333336f;
        if (code == 82) {
            this.renderer.camera().resetLook();
            this.renderer.recalculateTranslucency();
            return true;
        }
        if (code == 265) {
            this.renderer.camera().lookUp(0.083333336f);
            this.renderer.recalculateTranslucency();
            return true;
        }
        if (code == 264) {
            this.renderer.camera().lookDown(0.083333336f);
            this.renderer.recalculateTranslucency();
            return true;
        }
        if (code == 263) {
            this.renderer.camera().lookLeft(0.083333336f);
            this.renderer.recalculateTranslucency();
            return true;
        }
        if (code == 262) {
            this.renderer.camera().lookRight(0.083333336f);
            this.renderer.recalculateTranslucency();
            return true;
        }
        return super.m_7933_(code, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.scene != null) {
            this.renderer.dispose();
            this.f_169369_.remove(this.renderer);
        }
    }

    public void setSceneSource(Component src) {
        this.sceneSource = src;
    }

    public void setScene(BakedLevel scene) {
        this.scene = scene;
        this.updateSceneRenderers();
    }
}

