/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.jade.providers.client;

import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class CompactMachineProvider
implements IBlockComponentProvider {
    public static final CompactMachineProvider INSTANCE = new CompactMachineProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompactMachineBlockEntity machine = (CompactMachineBlockEntity)accessor.getBlockEntity();
        machine.getConnectedRoom().ifPresentOrElse(room -> tooltip.add((Component)TranslationUtil.tooltip(Tooltips.Machines.BOUND_TO, room)), () -> {
            MutableComponent newMachine = TranslationUtil.message(new ResourceLocation("compactmachines", "new_machine")).m_130940_(ChatFormatting.GREEN);
            tooltip.add((Component)newMachine);
        });
        machine.getOwnerUUID().ifPresent(ownerID -> {
            Player owner = accessor.getLevel().m_46003_(ownerID);
            if (owner != null) {
                MutableComponent ownerName = TranslationUtil.tooltip(Tooltips.Machines.OWNER, owner.m_5446_()).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)ownerName);
            }
        });
        if (accessor.getServerData().m_128441_("attached_tunnels")) {
            ListTag tag = (ListTag)accessor.getServerData().m_128423_("attached_tunnels");
            tooltip.add((Component)Component.m_237113_((String)""));
            tag.forEach(t -> {
                CompoundTag compound = (CompoundTag)t;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compound);
                IElementHelper helper = tooltip.getElementHelper();
                IElement icon = helper.item(itemStack).size(new Vec2(15.0f, 15.0f)).translate(new Vec2(-4.0f, -3.0f));
                tooltip.append(icon);
            });
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("compactmachines", "machine");
    }
}

