/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.util;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class TransformingVertexBuilder
implements VertexConsumer {
    private final VertexConsumer base;
    private final PoseStack transform;
    private final List<ObjectWithGlobal<?>> allObjects = new ArrayList();
    private final ObjectWithGlobal<Vec2> uv = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec3> pos = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec2i> overlay = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec2i> lightmap = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vector3f> normal = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vector4f> color = new ObjectWithGlobal(this);
    private final VertexFormat format;

    public TransformingVertexBuilder(VertexConsumer base, PoseStack transform, VertexFormat format) {
        this.base = base;
        this.transform = transform;
        this.format = format;
    }

    public TransformingVertexBuilder(VertexConsumer base, VertexFormat format) {
        this(base, new PoseStack(), format);
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type, PoseStack transform) {
        this(buffer.m_6299_(type), transform, type.m_110508_());
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type) {
        this(buffer, type, new PoseStack());
    }

    @Nonnull
    public VertexConsumer m_5483_(double x, double y, double z) {
        this.pos.putData(new Vec3(x, y, z));
        return this;
    }

    @Nonnull
    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        this.color.putData(new Vector4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f));
        return this;
    }

    @Nonnull
    public VertexConsumer m_7421_(float u, float v) {
        this.uv.putData(new Vec2(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer m_7122_(int u, int v) {
        this.overlay.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer m_7120_(int u, int v) {
        this.lightmap.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer m_5601_(float x, float y, float z) {
        this.normal.putData(new Vector3f(x, y, z));
        return this;
    }

    public void m_5752_() {
        for (VertexFormatElement element : this.format.m_86023_()) {
            if (element == DefaultVertexFormat.f_85804_) {
                this.pos.ifPresent(pos -> this.base.m_252986_(this.transform.m_85850_().m_252922_(), (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_));
                continue;
            }
            if (element == DefaultVertexFormat.f_85805_) {
                this.color.ifPresent(c -> this.base.m_85950_(c.x(), c.y(), c.z(), c.w()));
                continue;
            }
            if (element == DefaultVertexFormat.f_85806_) {
                this.uv.ifPresent(uv -> this.base.m_7421_(uv.f_82470_, uv.f_82471_));
                continue;
            }
            if (element == DefaultVertexFormat.f_85807_) {
                this.overlay.ifPresent(overlay -> this.base.m_7122_(overlay.x, overlay.y));
                continue;
            }
            if (element == DefaultVertexFormat.f_85808_) {
                this.lightmap.ifPresent(lightmap -> this.base.m_7120_(lightmap.x, lightmap.y));
                continue;
            }
            if (element != DefaultVertexFormat.f_85809_) continue;
            this.normal.ifPresent(normal -> this.base.m_252939_(this.transform.m_85850_().m_252943_(), normal.x(), normal.y(), normal.z()));
        }
        this.base.m_5752_();
        this.allObjects.forEach(ObjectWithGlobal::clear);
    }

    public void defaultColor(float r, float g, float b, float a) {
        this.color.setGlobal(new Vector4f(r, g, b, a));
    }

    public void m_7404_(int r, int g, int b, int a) {
        this.defaultColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public void m_141991_() {
        this.color.setGlobal(null);
    }

    public void setLight(int light) {
        this.lightmap.setGlobal(new Vec2i(light & 0xFF, light >> 16));
    }

    public void setNormal(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        vec.normalize();
        this.normal.setGlobal(vec);
    }

    public void setOverlay(int packedOverlayIn) {
        this.overlay.setGlobal(new Vec2i(packedOverlayIn & 0xFFFF, packedOverlayIn >> 16));
    }

    private static class ObjectWithGlobal<T> {
        @Nullable
        private T obj;
        private boolean isGlobal;

        public ObjectWithGlobal(TransformingVertexBuilder builder) {
            builder.allObjects.add(this);
        }

        public void putData(T newVal) {
            Preconditions.checkState((this.obj == null || this.isGlobal && this.obj.equals(newVal) ? 1 : 0) != 0);
            this.obj = newVal;
        }

        public void setGlobal(@Nullable T obj) {
            this.obj = obj;
            this.isGlobal = obj != null;
        }

        public T read() {
            Object ret = Preconditions.checkNotNull(this.obj);
            if (!this.isGlobal) {
                this.obj = null;
            }
            return (T)ret;
        }

        public boolean hasValue() {
            return this.obj != null;
        }

        public void ifPresent(Consumer<T> out) {
            if (this.hasValue()) {
                out.accept(this.read());
            }
        }

        public void clear() {
            if (!this.isGlobal) {
                this.obj = null;
            }
        }
    }

    private record Vec2i(int x, int y) {
    }
}

