/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines;

import dev.compactmods.machines.client.CreativeTabs;
import dev.compactmods.machines.command.Commands;
import dev.compactmods.machines.config.CommonConfig;
import dev.compactmods.machines.config.EnableVanillaRecipesConfigCondition;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Registries;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.dimension.WorldBorderFixer;
import dev.compactmods.machines.graph.Graph;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.room.data.LootFunctions;
import dev.compactmods.machines.shrinking.Shrinking;
import dev.compactmods.machines.tunnel.Tunnels;
import dev.compactmods.machines.upgrade.MachineRoomUpgrades;
import dev.compactmods.machines.wall.Walls;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="compactmachines")
public class CompactMachines {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Marker CONN_MARKER = MarkerManager.getMarker((String)"cm_connections");

    public CompactMachines() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        CompactMachines.initConfigs();
        CompactMachines.preparePackages();
        CompactMachines.registerEvents(modBus);
        Registries.setup(modBus);
        CraftingHelper.register((IConditionSerializer)EnableVanillaRecipesConfigCondition.Serializer.INSTANCE);
    }

    private static void initConfigs() {
        ModLoadingContext mlCtx = ModLoadingContext.get();
        mlCtx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.CONFIG);
        mlCtx.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.CONFIG);
    }

    private static void preparePackages() {
        Machines.prepare();
        Walls.prepare();
        Tunnels.prepare();
        Shrinking.prepare();
        CreativeTabs.prepare();
        Dimension.prepare();
        MachineRoomUpgrades.prepare();
        Graph.prepare();
        Commands.prepare();
        LootFunctions.prepare();
    }

    private static void registerEvents(IEventBus modBus) {
        WorldBorderFixer.registerEvents();
    }
}

