/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import terrablender.DimensionTypeTags;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.core.TerraBlender;
import terrablender.worldgen.IExtendedBiomeSource;
import terrablender.worldgen.IExtendedNoiseGeneratorSettings;
import terrablender.worldgen.IExtendedParameterList;

public class LevelUtils {
    public static void initializeOnServerStart(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Registry levelStemRegistry = registryAccess.m_175515_(Registries.f_256862_);
        long seed = server.m_129910_().m_246337_().m_245499_();
        for (Map.Entry entry : levelStemRegistry.m_6579_()) {
            LevelStem stem = (LevelStem)entry.getValue();
            LevelUtils.initializeBiomes((RegistryAccess)registryAccess, (Holder<DimensionType>)stem.f_63975_(), (ResourceKey<LevelStem>)((ResourceKey)entry.getKey()), stem.f_63976_(), seed);
        }
    }

    public static boolean shouldApplyToChunkGenerator(ChunkGenerator chunkGenerator) {
        return chunkGenerator instanceof NoiseBasedChunkGenerator && LevelUtils.shouldApplyToBiomeSource(chunkGenerator.m_62218_());
    }

    public static boolean shouldApplyToBiomeSource(BiomeSource biomeSource) {
        return biomeSource instanceof MultiNoiseBiomeSource;
    }

    public static RegionType getRegionTypeForDimension(Holder<DimensionType> dimensionType) {
        if (dimensionType.m_203656_(DimensionTypeTags.NETHER_REGIONS)) {
            return RegionType.NETHER;
        }
        if (dimensionType.m_203656_(DimensionTypeTags.OVERWORLD_REGIONS)) {
            return RegionType.OVERWORLD;
        }
        return null;
    }

    public static void initializeBiomes(RegistryAccess registryAccess, Holder<DimensionType> dimensionType, ResourceKey<LevelStem> levelResourceKey, ChunkGenerator chunkGenerator, long seed) {
        if (!LevelUtils.shouldApplyToChunkGenerator(chunkGenerator)) {
            return;
        }
        RegionType regionType = LevelUtils.getRegionTypeForDimension(dimensionType);
        NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
        NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_();
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)chunkGenerator.m_62218_();
        IExtendedBiomeSource biomeSourceEx = (IExtendedBiomeSource)biomeSource;
        if (regionType == null) {
            return;
        }
        ((IExtendedNoiseGeneratorSettings)generatorSettings).setRegionType(regionType);
        Climate.ParameterList parameters = biomeSource.m_274409_();
        IExtendedParameterList parametersEx = (IExtendedParameterList)parameters;
        parametersEx.initializeForTerraBlender(registryAccess, regionType, seed);
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        ImmutableList.Builder builder = ImmutableList.builder();
        Regions.get(regionType).forEach(region -> region.addBiomes((Registry<Biome>)biomeRegistry, pair -> {
            if (biomeRegistry.m_203636_((ResourceKey)pair.getSecond()).isPresent()) {
                builder.add((Object)biomeRegistry.m_246971_((ResourceKey)pair.getSecond()));
            }
        }));
        biomeSourceEx.appendDeferredBiomesList((List<Holder<Biome>>)builder.build());
        TerraBlender.LOGGER.info(String.format("Initialized TerraBlender biomes for level stem %s", levelResourceKey.m_135782_()));
    }
}

