/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfences.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleGate
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<FenceGateState> GATESTATE = EnumProperty.m_61587_((String)"fencepart", FenceGateState.class);
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape EE = DoubleGate.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = DoubleGate.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EE_COLLISION = DoubleGate.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)24.0, (double)9.0);
    protected static final VoxelShape NN_COLLISION = DoubleGate.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)24.0, (double)16.0);

    public DoubleGate(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(GATESTATE, (Comparable)((Object)FenceGateState.TOP))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    private BlockState updateFenceGateState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        FenceGateState newState = above ? FenceGateState.BOTTOM : FenceGateState.TOP;
        return (BlockState)state.m_61124_(GATESTATE, (Comparable)((Object)newState));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.updateFenceGateState(state, level, pos);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? NN_COLLISION : EE_COLLISION;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState baseState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context));
        return this.updateFenceGateState(baseState, (LevelAccessor)level, pos);
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        int j = direction.m_122429_();
        int k = direction.m_122431_();
        Vec3 vector3d = context.m_43720_();
        double d0 = vector3d.f_82479_ - (double)blockpos.m_123341_();
        double d1 = vector3d.f_82481_ - (double)blockpos.m_123343_();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!level.f_46443_) {
            ItemStack itemstack = player.m_21120_(handIn);
            if (itemstack.m_41720_() == this.m_5456_()) {
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
                return InteractionResult.PASS;
            }
            this.fenceGate(level, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING));
            boolean currentState = (Boolean)state.m_61143_((Property)OPEN);
            boolean newState = !currentState;
            state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(newState));
            level.m_46597_(pos, state);
            level.m_5594_(null, pos, newState ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? NN : EE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, GATESTATE, OPEN, HINGE});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        Block block = level.m_8055_(pos).m_60734_();
        Block below = level.m_8055_(pos.m_6625_(1)).m_60734_();
        if (block == this && below == block) {
            DoorHingeSide hinge = (DoorHingeSide)level.m_8055_(pos.m_6625_(1)).m_61143_(HINGE);
            level.m_46597_(pos, (BlockState)state.m_61124_(HINGE, (Comparable)hinge));
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    private void fenceGate(Level world, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this && (Boolean)state.m_61143_((Property)OPEN) != bool && ((Direction)state.m_61143_((Property)FACING)).equals((Object)dir)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.m_7918_(x, y, z);
                        this.fenceGate(world, newPos, bool, dir);
                    }
                }
            }
        }
    }

    public static enum FenceGateState implements StringRepresentable
    {
        BOTTOM("bottom"),
        TOP("top");

        private final String name;

        private FenceGateState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

