/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.registries;

import auviotre.enigmatic.delicacy.registries.EnigmaticDelightBlocks;
import java.util.OptionalInt;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class EnigmaticDelightConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ETHERIUM_ORE = EnigmaticDelightConfiguredFeatures.registerKey("etherium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASTRAL_TREE = EnigmaticDelightConfiguredFeatures.registerKey("astral_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASTRAL_SMALL_TREE = EnigmaticDelightConfiguredFeatures.registerKey("astral_small_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASTRAL_FANCY_TREE = EnigmaticDelightConfiguredFeatures.registerKey("astral_fancy_tree");
    private static final BlockStateProvider RANDOM_ASTRAL_LEAVES = new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)EnigmaticDelightBlocks.BLOSSOMING_ASTRAL_LEAVES.m_49966_(), 1).m_146271_((Object)EnigmaticDelightBlocks.ASTRAL_LEAVES.m_49966_(), 11));

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        EnigmaticDelightConfiguredFeatures.register(context, ASTRAL_TREE, Feature.f_65760_, EnigmaticDelightConfiguredFeatures.createFloweringOak().m_68251_());
        EnigmaticDelightConfiguredFeatures.register(context, ASTRAL_SMALL_TREE, Feature.f_65760_, EnigmaticDelightConfiguredFeatures.createSmallFloweringOak().m_68251_());
        EnigmaticDelightConfiguredFeatures.register(context, ASTRAL_FANCY_TREE, Feature.f_65760_, EnigmaticDelightConfiguredFeatures.createFancyFloweringOak().m_68251_());
        BlockMatchTest endStoneReplace = new BlockMatchTest(Blocks.f_50259_);
        EnigmaticDelightConfiguredFeatures.register(context, ETHERIUM_ORE, Feature.f_65731_, new OreConfiguration((RuleTest)endStoneReplace, EnigmaticDelightBlocks.ETHERIUM_ORE.m_49966_(), 3));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("enigmaticdelicacy", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFloweringOak() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)EnigmaticDelightBlocks.ASTRAL_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 3, 0), RANDOM_ASTRAL_LEAVES, (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createSmallFloweringOak() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)EnigmaticDelightBlocks.ASTRAL_LOG), (TrunkPlacer)new StraightTrunkPlacer(2, 1, 0), RANDOM_ASTRAL_LEAVES, (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyFloweringOak() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)EnigmaticDelightBlocks.ASTRAL_LOG), (TrunkPlacer)new FancyTrunkPlacer(3, 10, 0), RANDOM_ASTRAL_LEAVES, (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
    }
}

