/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import auviotre.enigmatic.delicacy.contents.items.CurseBlade;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CurseCrystalPendant
extends ItemBaseCurio {
    public static Omniconfig.PerhapsParameter healingAmountModifier;
    public static Omniconfig.PerhapsParameter injuryRecoveryRate;

    public CurseCrystalPendant() {
        super(ItemBaseCurio.getDefaultProperties().m_41486_().m_41497_(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CursedSoulCrystalPendant");
        healingAmountModifier = builder.comment("The healing amount modifier. Measures in percentage.").max(100.0).getPerhaps("HealingAmountModifier", 25);
        injuryRecoveryRate = builder.comment("The ratio of recovery base on the damage you received. Measures in percentage.").max(100.0).getPerhaps("InjuryRecoveryRate", 24);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalPendant1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{injuryRecoveryRate + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalPendant2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{healingAmountModifier + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalPendant3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalPendant4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalPendant5");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalSoulAmount", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{CurseBlade.SoulHelper.getSoulAmount(stack)});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        if (SuperpositionHandler.hasCurio((LivingEntity)victim, (Item)this)) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                float attackerPercent = attacker.m_21223_() / attacker.m_21233_();
                System.out.print(Math.pow(2.0, attackerPercent - 1.0f) + "\n");
                event.setAmount(event.getAmount() * (float)Math.pow(2.0, attackerPercent - 1.0f));
            }
            victim.m_5634_(event.getAmount() * 0.4f);
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)this)) {
            event.setAmount(event.getAmount() * healingAmountModifier.getValue().asModifier(true));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSoulReviving(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).m_9236_()) instanceof ServerLevel) {
            ItemStack curioStack;
            int soulAmount;
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)this) && (soulAmount = CurseBlade.SoulHelper.getSoulAmount(curioStack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)this))) > 0) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                player.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT, 600, 3));
                float maxHealth = player.m_21233_() * 0.75f;
                if ((float)soulAmount < maxHealth) {
                    player.m_21153_((float)soulAmount);
                    CurseBlade.SoulHelper.setSoulAmount(curioStack, 0);
                } else {
                    player.m_21153_(maxHealth);
                    CurseBlade.SoulHelper.setSoulAmount(curioStack, Mth.m_14143_((float)((float)soulAmount - maxHealth)));
                }
                serverLevel.m_8767_((ParticleOptions)EnigmaticAddonParticles.RED_STAR_DUST, player.m_20185_(), player.m_20186_(), player.m_20189_(), 24, (double)(player.m_20205_() / 2.0f), (double)player.m_20206_(), (double)(player.m_20205_() / 2.0f), 0.0);
            }
        }
    }

    public CreativeModeTab getCreativeTab() {
        return null;
    }
}

