/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.delicacy.contents.EnigmaticFoods;
import auviotre.enigmatic.delicacy.contents.objects.abyss.AbyssDataCapability;
import auviotre.enigmatic.delicacy.contents.objects.abyss.IAbyssData;
import auviotre.enigmatic.delicacy.handlers.EnigmaticDelightEventHandler;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModItems;

public class AbyssalStew
extends ConsumableItem
implements ICursed,
IEldritch {
    public static Omniconfig.BooleanParameter barDisplay;
    public static Omniconfig.IntParameter duration;
    public static Omniconfig.IntParameter killPunishment;
    public static Omniconfig.PerhapsParameter damageModifier;
    public static Omniconfig.PerhapsParameter resistanceModifier;
    public static Omniconfig.PerhapsParameter theInfinitumDisAttackProbability;
    public static Omniconfig.PerhapsParameter theInfinitumAttackModifierPerHarmfulEffect;
    public static Omniconfig.PerhapsParameter eldritchAmuletDamageBoost;
    public static Omniconfig.PerhapsParameter eldritchAmuletDamageResistance;

    public AbyssalStew() {
        super(ModItems.bowlFoodItem((FoodProperties)EnigmaticFoods.ABYSS_STEW.m_38767_()).m_41497_(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("AbyssalStew");
        if (builder.config.getSidedType() == Configuration.SidedConfigType.CLIENT) {
            barDisplay = builder.comment("Whether to render the duration bar of the Abyss effect.").getBoolean("BarDisplay", true);
        } else {
            duration = builder.comment("The effect duration of Abyssal Stew. Measured in tick.").getInt("Duration", 18000);
            killPunishment = builder.comment("The reduced duration time when killing creatures. Measured in tick.").getInt("KillPunishment", 40);
            damageModifier = builder.comment("The damage modifier when you have the effect of Abyssal Stew. Measured in percentage.").getPerhaps("DamageModifier", 30);
            resistanceModifier = builder.comment("The damage resistance modifier when you have the effect of Abyssal Stew. Measured in percentage.").max(100.0).getPerhaps("ResistanceModifier", 25);
            theInfinitumDisAttackProbability = builder.comment("The probability to making next attack received ineffective when you hold The Infinitum and have the effect of Abyssal Stew. Measured in percentage.").max(80.0).getPerhaps("TheInfinitumDisAttackProbability", 25);
            theInfinitumAttackModifierPerHarmfulEffect = builder.comment("The attack damage modifier per every harmful effect the target has when you hold The Infinitum and have the effect of Abyssal Stew. Measured in percentage.").max(50.0).getPerhaps("TheInfinitumAttackModifierPerHarmfulEffect", 8);
            eldritchAmuletDamageBoost = builder.comment("The attack damage modifier when you equip The Testament of Contempt and have the effect of Abyssal Stew. Measured in percentage.").max(100.0).getPerhaps("EldritchAmuletDamageBoost", 80);
            eldritchAmuletDamageResistance = builder.comment("The damage resistance rate when you equip The Testament of Contempt and have the effect of Abyssal Stew. Measured in percentage.").max(100.0).getPerhaps("EldritchAmuletDamageResistance", 40);
        }
        builder.popPrefix();
    }

    public static int getAbyssTick(Player player) {
        LazyOptional abyssData = SuperAddonHandler.getCapability((Player)player, AbyssDataCapability.ABYSS_DATA);
        return abyssData.isPresent() ? ((IAbyssData)abyssData.orElse(null)).getTick() : -1;
    }

    public static void giveHeart(Player player) {
        if (player.m_7500_()) {
            return;
        }
        ItemStack stack = EnigmaticItems.ABYSSAL_HEART.m_7968_();
        if (!player.m_36356_(stack)) {
            PermanentItemEntity itemEntity = new PermanentItemEntity(player.m_9236_(), player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), stack);
            itemEntity.m_146915_(true);
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            player.m_9236_().m_7967_((Entity)itemEntity);
        } else {
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{damageModifier + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{resistanceModifier + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssalStew6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateWorthyOnesOnly(list);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && SuperAddonHandler.isAbyssBoost((Player)player)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.abyssBoost");
                if (SuperpositionHandler.getPersistentBoolean((Player)player, (String)"AbyssHeartBonus", (boolean)false)) {
                    ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssStewBoost_alt");
                } else {
                    ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.abyssStewBoost");
                }
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(list);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (SuperpositionHandler.isTheWorthyOne((Player)player)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        consumer.m_216990_(EnigmaticSounds.CHARGED_ON);
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            if (stack.m_150930_((Item)this)) {
                if (SuperAddonHandler.isAbyssBoost((Player)player) && !SuperpositionHandler.getPersistentBoolean((Player)player, (String)"AbyssHeartBonus", (boolean)false)) {
                    SuperpositionHandler.setPersistentBoolean((Player)player, (String)"AbyssHeartBonus", (boolean)true);
                    if (!player.m_9236_().f_46443_) {
                        AbyssalStew.giveHeart(player);
                    }
                }
                if (!player.m_9236_().f_46443_) {
                    LazyOptional abyssData = SuperAddonHandler.getCapability((Player)player, AbyssDataCapability.ABYSS_DATA);
                    if (AbyssalStew.getAbyssTick(player) > 0) {
                        AbyssalStew.giveHeart(player);
                    }
                    abyssData.ifPresent(capability -> capability.setTick(duration.getValue()));
                }
            }
        }
        return super.m_5922_(stack, level, consumer);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingDamageEvent event) {
        Player player;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (victim instanceof Player && SuperAddonHandler.isAbyssBoost((Player)(player = (Player)victim))) {
            LivingEntity living;
            event.setAmount(event.getAmount() * resistanceModifier.getValue().asModifierInverted());
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.ELDRITCH_AMULET) && attacker instanceof LivingEntity && (living = (LivingEntity)attacker).m_21223_() <= player.m_21233_()) {
                event.setAmount(event.getAmount() * eldritchAmuletDamageResistance.getValue().asModifierInverted());
            }
        }
        if (attacker instanceof Player && SuperAddonHandler.isAbyssBoost((Player)(player = (Player)attacker))) {
            event.setAmount(event.getAmount() * damageModifier.getValue().asModifier(true));
            victim.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.ABYSS_CORRUPTION_EFFECT, 600));
        }
        if (attacker instanceof Player && SuperAddonHandler.isAbyssBoost((Player)(player = (Player)attacker))) {
            boolean infinitum = false;
            if (player.m_21205_().m_150930_((Item)EnigmaticItems.THE_INFINITUM)) {
                infinitum = true;
            } else if (player.m_21206_().m_150930_((Item)EnigmaticItems.THE_INFINITUM)) {
                infinitum = true;
            }
            if (infinitum) {
                float harmCount = 0.0f;
                for (MobEffectInstance mobEffectInstance : victim.m_21220_()) {
                    if (mobEffectInstance.m_19544_().m_19486_()) continue;
                    harmCount += (float)mobEffectInstance.m_19564_() * 0.5f;
                }
                if (harmCount > 0.0f) {
                    event.setAmount(event.getAmount() * (1.0f + theInfinitumAttackModifierPerHarmfulEffect.getValue().asModifier() * harmCount));
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.ELDRITCH_AMULET) && victim.m_21223_() <= player.m_21233_()) {
                event.setAmount(event.getAmount() * eldritchAmuletDamageBoost.getValue().asModifier(true));
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Player player;
        Player player22;
        HashMap<ServerPlayer, Integer> map = new HashMap<ServerPlayer, Integer>();
        LivingEntity entity = event.getEntity();
        List nearbyPlayers = entity.m_9236_().m_45976_(Player.class, entity.m_20191_().m_82400_(10.0));
        for (Player player22 : nearbyPlayers) {
            if (!(player22 instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player22;
            if (map.containsKey(player22)) {
                map.replace(serverPlayer, (Integer)map.get(player22) + killPunishment.getValue());
                continue;
            }
            map.put(serverPlayer, killPunishment.getValue());
        }
        player22 = event.getSource().m_7639_();
        if (player22 instanceof Player && !nearbyPlayers.contains(player = player22) && AbyssalStew.getAbyssTick(player) > 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (map.containsKey(player)) {
                map.replace(serverPlayer, (Integer)map.get(player) + killPunishment.getValue());
            } else {
                map.put(serverPlayer, killPunishment.getValue());
            }
        }
        for (Player player22 : map.keySet()) {
            SuperAddonHandler.getCapability((Player)player22, AbyssDataCapability.ABYSS_DATA).ifPresent(arg_0 -> AbyssalStew.lambda$onEntityDeath$1(map, (ServerPlayer)player22, arg_0));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        if (EnigmaticDelightEventHandler.DESOLATION_BOOST_BOXES.values().stream().anyMatch(arg_0 -> ((AABB)entity.m_20191_()).m_82381_(arg_0))) {
            event.setSpawnCancelled(true);
            event.setCanceled(true);
        }
    }

    private static /* synthetic */ void lambda$onEntityDeath$1(Map map, ServerPlayer player, IAbyssData cap) {
        if (cap.getTick() > 0 && cap.getTick() <= (Integer)map.get(player)) {
            AbyssalStew.giveHeart((Player)player);
        }
        cap.tick((Player)player, (Integer)map.get(player));
    }
}

