/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy;

import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.registries.AbstractRegistry;
import auviotre.enigmatic.delicacy.client.handlers.ClientEventHandler;
import auviotre.enigmatic.delicacy.contents.blocks.AstralWoodProperties;
import auviotre.enigmatic.delicacy.handlers.AppleSkinCompatHandler;
import auviotre.enigmatic.delicacy.handlers.EnigmaticDelightEventHandler;
import auviotre.enigmatic.delicacy.handlers.OmniconfigDelightHandler;
import auviotre.enigmatic.delicacy.handlers.ThirstCompatHandler;
import auviotre.enigmatic.delicacy.packets.client.PacketAbyssCorruption;
import auviotre.enigmatic.delicacy.packets.server.PacketAbyssSync;
import auviotre.enigmatic.delicacy.proxy.ClientProxy;
import auviotre.enigmatic.delicacy.proxy.CommonProxy;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightBlocks;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEnchantments;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEntities;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightMenus;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightParticles;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightRecipes;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightTabs;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightTags;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightTiles;
import com.aizistral.enigmaticlegacy.brewing.SpecialBrewingRecipe;
import com.aizistral.enigmaticlegacy.crafting.HiddenRecipe;
import com.aizistral.enigmaticlegacy.objects.LoggerWrapper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod(value="enigmaticdelicacy")
public class EnigmaticDelicacy {
    public static final String MODID = "enigmaticdelicacy";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final LoggerWrapper LOGGER = new LoggerWrapper("Enigmatic Delicacy");
    public static ModList mods = ModList.get();
    public static SimpleChannel packetInstance;

    public EnigmaticDelicacy() {
        LOGGER.info("Constructing mod instance...");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        OmniconfigDelightHandler.initialize();
        AbstractRegistry.loadClass(EnigmaticDelightTabs.class);
        AbstractRegistry.loadClass(EnigmaticDelightItems.class);
        AbstractRegistry.loadClass(EnigmaticDelightTiles.class);
        AbstractRegistry.loadClass(EnigmaticDelightMenus.class);
        AbstractRegistry.loadClass(EnigmaticDelightBlocks.class);
        AbstractRegistry.loadClass(EnigmaticDelightEffects.class);
        AbstractRegistry.loadClass(EnigmaticDelightRecipes.class);
        AbstractRegistry.loadClass(EnigmaticDelightEntities.class);
        AbstractRegistry.loadClass(EnigmaticDelightParticles.class);
        AbstractRegistry.loadClass(EnigmaticDelightEnchantments.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onLoadComplete);
        modEventBus.register((Object)this);
        modEventBus.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)new AstralWoodProperties());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnigmaticDelightEventHandler());
        if (ModList.get().isLoaded("thirst")) {
            LOGGER.info("Thirst Compat.");
            MinecraftForge.EVENT_BUS.register((Object)new ThirstCompatHandler());
        }
        if (ModList.get().isLoaded("appleskin")) {
            LOGGER.info("AppleSkin Compat.");
            MinecraftForge.EVENT_BUS.register((Object)new AppleSkinCompatHandler());
        }
        LOGGER.info("Mod instance constructed successfully.");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing common setup phase...");
        PROXY.commonInit();
        LOGGER.info("Registering packets...");
        packetInstance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
        packetInstance.registerMessage(0, PacketAbyssSync.class, PacketAbyssSync::encode, PacketAbyssSync::decode, PacketAbyssSync::handle);
        packetInstance.registerMessage(1, PacketAbyssCorruption.class, PacketAbyssCorruption::encode, PacketAbyssCorruption::decode, PacketAbyssCorruption::handle);
        LOGGER.info("Common setup phase finished successfully.");
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Initializing load completion phase...");
        LOGGER.info("Registering brewing recipes...");
        if (OmniconfigAddonHandler.isItemEnabled((Object)((Object)EnigmaticDelightItems.CURSE_POTION))) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new SpecialBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.RECALL_POTION}), Ingredient.m_204132_(EnigmaticDelightTags.CURSED_SOUL_CRYSTAL), new ItemStack((ItemLike)EnigmaticDelightItems.CURSE_POTION), new ResourceLocation(MODID, "curse_potion")));
        }
        HiddenRecipe.addRecipe((ItemStack)new ItemStack((ItemLike)EnigmaticDelightBlocks.INFINISOIL), (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.RICH_SOIL.get()), new ItemStack((ItemLike)EnigmaticDelightItems.GLISTENING_HEART), new ItemStack((ItemLike)ModItems.RICH_SOIL.get()), new ItemStack((ItemLike)EnigmaticItems.INFINIMEAL), new ItemStack((ItemLike)Blocks.f_50453_), new ItemStack((ItemLike)EnigmaticItems.INFINIMEAL), new ItemStack((ItemLike)ModItems.RICH_SOIL.get()), new ItemStack((ItemLike)EnigmaticDelightItems.GLISTENING_HEART), new ItemStack((ItemLike)ModItems.RICH_SOIL.get())});
        HiddenRecipe.addRecipe((ItemStack)new ItemStack((ItemLike)EnigmaticDelightBlocks.DIVINE_FRUIT_PIE_BLOCK), (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.MILK_BOTTLE.get()), new ItemStack((ItemLike)EnigmaticItems.ICHOR_BOTTLE), new ItemStack((ItemLike)ModItems.MILK_BOTTLE.get()), new ItemStack((ItemLike)EnigmaticDelightItems.PURIFIED_DRAGON_BREATH), new ItemStack((ItemLike)EnigmaticDelightItems.ASTRAL_FRUIT_SLICE), new ItemStack((ItemLike)EnigmaticDelightItems.PURIFIED_DRAGON_BREATH), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST), new ItemStack((ItemLike)Items.f_42399_), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST)});
        LOGGER.info("Load completion phase finished successfully");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Initializing client setup phase...");
        PROXY.clientInit();
        LOGGER.info("Client setup phase finished successfully.");
    }

    @SubscribeEvent
    public void onCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EnigmaticDelightTabs.MAIN) {
            EnigmaticDelightTabs.build(event);
        }
    }
}

