/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class PanicNecklaceItem
extends WearableArtifactItem {
    public PanicNecklaceItem() {
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return ModGameRules.PANIC_NECKLACE_SPEED_DURATION.get() > 0 && ModGameRules.PANIC_NECKLACE_SPEED_LEVEL.get() > 0;
    }

    private EventResult onLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        if (this.isEquippedBy(entity) && !entity.m_9236_().m_5776_() && amount >= 1.0f && !this.isOnCooldown(entity)) {
            int duration = ModGameRules.PANIC_NECKLACE_SPEED_DURATION.get();
            int level = ModGameRules.PANIC_NECKLACE_SPEED_LEVEL.get();
            if (duration > 0 && level > 0) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, level - 1, false, false));
                this.addCooldown(entity, ModGameRules.PANIC_NECKLACE_COOLDOWN.get());
            }
        }
        return EventResult.pass();
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11673_;
    }
}

