/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.coolrain.mixin;

import com.leclowndu93150.coolrain.CoolRainSounds;
import com.leclowndu93150.coolrain.tags.ModTags;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class RainMixin {
    @Shadow
    private int f_109450_;
    @Shadow
    @Final
    private Minecraft f_109461_;

    @Inject(method={"tickRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V", ordinal=0)}, cancellable=true)
    private void onRainSoundAbove(Camera camera, CallbackInfo ci) {
        this.handleCustomRainSound(camera, ci, true);
    }

    @Inject(method={"tickRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V", ordinal=1)}, cancellable=true)
    private void onRainSoundNormal(Camera camera, CallbackInfo ci) {
        this.handleCustomRainSound(camera, ci, false);
    }

    @Unique
    private void handleCustomRainSound(Camera camera, CallbackInfo ci, boolean isMuffled) {
        ClientLevel world = this.f_109461_.f_91073_;
        if (world == null) {
            return;
        }
        RandomSource random = RandomSource.m_216335_((long)(world.m_46467_() * 312987231L));
        BlockPos cameraPos = BlockPos.m_274446_((Position)camera.m_90583_());
        BlockPos soundPos = this.findRainSoundPosition(world, cameraPos, random);
        if (soundPos == null) {
            return;
        }
        BlockState blockState = world.m_8055_(soundPos);
        this.playRainSound(world, soundPos, blockState, random, isMuffled);
        ci.cancel();
    }

    @Unique
    private BlockPos findRainSoundPosition(ClientLevel world, BlockPos cameraPos, RandomSource random) {
        for (int i = 0; i < 50; ++i) {
            int offsetZ;
            int offsetX = random.m_188503_(21) - 10;
            BlockPos heightmapPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos.m_7918_(offsetX, 0, offsetZ = random.m_188503_(21) - 10));
            if (heightmapPos.m_123342_() <= world.m_141937_() || heightmapPos.m_123342_() > cameraPos.m_123342_() + 10 || heightmapPos.m_123342_() < cameraPos.m_123342_() - 10) continue;
            return heightmapPos.m_7495_();
        }
        return null;
    }

    @Unique
    private void playRainSound(ClientLevel world, BlockPos pos, BlockState blockState, RandomSource random, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        float volume = this.getRainSoundVolume(blockState, isMuffled);
        float pitch = this.getRainSoundPitch(blockState, random);
        boolean shouldAttenuate = this.shouldAttenuateSound(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() || sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            world.m_245747_(pos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            world.m_245747_(pos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.1f, pitch, false);
        }
        world.m_245747_(pos, sound, SoundSource.WEATHER, volume, pitch, shouldAttenuate);
    }

    @Unique
    private SoundEvent getRainSoundForBlock(BlockState blockState) {
        if (blockState.m_60713_(Blocks.f_49991_) || blockState.m_60713_(Blocks.f_50450_) || blockState.m_60713_(Blocks.f_50683_) || blockState.m_60713_(Blocks.f_50684_) || blockState.m_204336_(ModTags.Blocks.LAVA_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_LAVA.get();
        }
        if (blockState.m_60713_(Blocks.f_49990_) || blockState.m_204336_(ModTags.Blocks.WATER_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_WATER.get();
        }
        if (blockState.m_60713_(Blocks.f_152490_) || blockState.m_60713_(Blocks.f_152492_) || blockState.m_60713_(Blocks.f_152491_) || blockState.m_60713_(Blocks.f_152495_) || blockState.m_60713_(Blocks.f_152494_) || blockState.m_60713_(Blocks.f_152493_) || blockState.m_204336_(ModTags.Blocks.AMETHYST_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_AMETHYST.get();
        }
        if (blockState.m_60713_(Blocks.f_50065_) || blockState.m_204336_(ModTags.Blocks.NOTEBLOCK_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.METAL_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_IRON) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_COPPER) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_GOLD) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_NETHERITE) || blockState.m_60713_(Blocks.f_50075_) || blockState.m_60713_(Blocks.f_50074_) || blockState.m_60713_(Blocks.f_50721_) || blockState.m_60713_(Blocks.f_152504_) || blockState.m_60713_(Blocks.f_152598_) || blockState.m_60713_(Blocks.f_152599_) || blockState.m_60713_(Blocks.f_152600_) || blockState.m_60713_(Blocks.f_50681_) || blockState.m_60713_(Blocks.f_50682_) || blockState.m_60713_(Blocks.f_50376_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_METAL.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.GLASS_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_GLASS_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_GLASS_PANES) || blockState.m_60713_(Blocks.f_50058_) || blockState.m_60713_(Blocks.f_152498_) || blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50354_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_GLASS.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.FABRIC_BLOCKS) || blockState.m_204336_(BlockTags.f_13089_) || blockState.m_204336_(BlockTags.f_215838_) || blockState.m_204336_(BlockTags.f_13038_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_FABRIC.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.FOLIAGE_BLOCKS) || blockState.m_204336_(BlockTags.f_13035_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get();
        }
        return SoundEvents.f_12541_;
    }

    @Unique
    private float getRainSoundVolume(BlockState blockState, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FABRIC.get()) {
            return 0.75f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_WATER.get()) {
            return 0.175f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get()) {
            return 0.3f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            return 0.2f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 0.2f;
        }
        if (isMuffled) {
            return 0.1f;
        }
        if (sound == SoundEvents.f_12541_) {
            return 0.2f;
        }
        return 0.5f;
    }

    @Unique
    private float getRainSoundPitch(BlockState blockState, RandomSource random) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get() || sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 1.0f;
        }
        if (sound == SoundEvents.f_12541_) {
            return 1.0f;
        }
        return (float)random.m_216332_(8, 12) * 0.1f;
    }

    @Unique
    private boolean shouldAttenuateSound(BlockState blockState) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        return sound != CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() && sound != CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get() && sound != SoundEvents.f_12541_;
    }
}

