/*
 * Decompiled with CFR 0.152.
 */
package ru.hollowhorizon.additions.questing.client;

import java.util.function.Function;
import org.lwjgl.glfw.GLFW;
import ru.hollowhorizon.additions.questing.config.QuestAnimationsConfig;

public class Animator {
    private final float duration;
    private final Function<Float, Float> interpolator;
    private float fromValue;
    private float toValue;
    private double lastSetTime;
    private float value;

    public Animator(float startValue, float duration, Function<Float, Float> interpolator) {
        double startTime = this.getCurrentTime();
        this.duration = duration;
        this.interpolator = interpolator != null ? interpolator : t -> t;
        this.fromValue = startValue;
        this.toValue = startValue;
        this.lastSetTime = startTime;
        this.value = startValue;
    }

    public Animator(float startValue, float duration) {
        this(startValue, duration, null);
    }

    public void set(float target, Float from) {
        if (this.toValue == target && from == null) {
            return;
        }
        this.fromValue = from != null ? from.floatValue() : this.get();
        this.toValue = target;
        this.lastSetTime = this.getCurrentTime();
    }

    public void set(float target) {
        this.set(target, null);
    }

    public float get() {
        return this.value;
    }

    public void update() {
        double now = this.getCurrentTime();
        float t = (float)Math.min(Math.max((now - this.lastSetTime) / (double)this.duration, 0.0), 1.0);
        float k = (Boolean)QuestAnimationsConfig.SMOOTH_ANIMATIONS.get() != false ? this.interpolator.apply(Float.valueOf(t)).floatValue() : t;
        this.value = this.fromValue + (this.toValue - this.fromValue) * k;
    }

    public void add(float value) {
        this.set(this.get() + value);
    }

    public boolean isAnimating() {
        double now = this.getCurrentTime();
        return now - this.lastSetTime < (double)this.duration;
    }

    private double getCurrentTime() {
        return GLFW.glfwGetTime();
    }

    public float getToValue() {
        return this.toValue;
    }

    public float getFromValue() {
        return this.fromValue;
    }
}

