/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.worldgen.threading_issues.common;

import com.ishland.c2me.fixes.worldgen.threading_issues.common.Config;
import com.ishland.c2me.fixes.worldgen.threading_issues.common.debug.SMAPSourceDebugExtension;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedThreadLocalRandom
extends SingleThreadedRandomSource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CheckedThreadLocalRandom");
    private static final ThreadLocal<SingleThreadedRandomSource> FALLBACK = ThreadLocal.withInitial(() -> new SingleThreadedRandomSource(new Random().nextLong()));
    private final Supplier<Thread> owner;

    public CheckedThreadLocalRandom(long seed, Supplier<Thread> owner) {
        super(seed);
        this.owner = Objects.requireNonNull(owner);
    }

    private boolean isSafe() {
        boolean notOwner;
        Thread owner = this.owner != null ? this.owner.get() : null;
        boolean bl = notOwner = owner != null && Thread.currentThread() != owner;
        if (notOwner) {
            this.handleNotOwner();
            return false;
        }
        return true;
    }

    private void handleNotOwner() {
        StringBuilder builder = new StringBuilder();
        String exceptionMessage = "ThreadLocalRandom accessed from a different thread (owner: %s, current: %s)".formatted(this.owner.get().getName(), Thread.currentThread().getName());
        builder.append(exceptionMessage).append('\n');
        builder.append("This is usually NOT a bug in C2ME, but a bug in another mod or in vanilla code. \n");
        builder.append("Possible solutions: \n");
        builder.append("  - Find possible causes in the stack trace below and \n");
        builder.append("    - if caused by another mod, report this to the corresponding mod authors \n");
        builder.append("    - if no other mods are involved, report this to C2ME \n");
        ConcurrentModificationException exception = new ConcurrentModificationException(exceptionMessage);
        try {
            SMAPSourceDebugExtension.enhanceStackTrace(exception, false);
        }
        catch (Throwable t) {
            LOGGER.error("Error occurred while processing error stack trace", t);
            exception = new ConcurrentModificationException(exceptionMessage);
        }
        String s = builder.toString();
        LOGGER.error(s, (Throwable)exception);
        if (Config.enforceSafeWorldRandomAccess) {
            throw new RuntimeException(String.format("%s \n (You may make this a fatal warning instead of a hard crash with fixes.enforceSafeWorldRandomAccess setting in c2me.toml)", s), exception){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
    }

    public void m_188584_(long seed) {
        if (this.isSafe()) {
            super.m_188584_(seed);
        } else {
            FALLBACK.get().m_188584_(seed);
        }
    }

    public int m_64707_(int bits) {
        if (this.isSafe()) {
            return super.m_64707_(bits);
        }
        return FALLBACK.get().m_64707_(bits);
    }

    static {
        if (Config.enforceSafeWorldRandomAccess) {
            LOGGER.info("Enforcing safe world random access");
        } else {
            LOGGER.warn("Not enforcing safe world random access");
        }
    }
}

