/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.worldgen.threading_issues.asm;

import com.ishland.c2me.base.common.util.ASMUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMTransformerMakeVolatile {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME (c2me-fixes-worldgen-threading-issues) ASM Transformer");
    private static final Map<String, List<String>> makeVolatileFields = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> makeVolatileFieldsMapped;

    public static void transform(ClassNode classNode) {
        List<String> pendingFields = makeVolatileFieldsMapped.get(classNode.name);
        if (pendingFields != null) {
            classNode.fields.stream().filter(fieldNode -> pendingFields.contains(fieldNode.name + ":" + fieldNode.desc)).forEach(fieldNode -> {
                LOGGER.debug("Making field L{};{}:{} volatile", new Object[]{classNode.name, fieldNode.name, fieldNode.desc});
                fieldNode.access |= 0x40;
            });
        }
    }

    static {
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/MineshaftPieces$MineShaftCorridor", List.of("f_227728_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/NetherFortressPieces$MonsterThrone", List.of("f_228354_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/NetherFortressPieces$CastleSmallCorridorLeftTurnPiece", List.of("f_228230_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/NetherFortressPieces$CastleSmallCorridorRightTurnPiece", List.of("f_228292_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/NetherFortressPieces$StartPiece", List.of("f_228507_:Lnet/minecraft/world/level/levelgen/structure/structures/NetherFortressPieces$PieceWeight;"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/OceanMonumentPieces$RoomDefinition", List.of("f_228939_:Z", "f_228940_:Z", "f_228941_:I"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/OceanMonumentPieces$MonumentBuilding", List.of("f_228643_:Lnet/minecraft/world/level/levelgen/structure/structures/OceanMonumentPieces$RoomDefinition;", "f_228644_:Lnet/minecraft/world/level/levelgen/structure/structures/OceanMonumentPieces$RoomDefinition;"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/TemplateStructurePiece", List.of("f_73658_:Lnet/minecraft/core/BlockPos;"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/StrongholdPieces$ChestCorridor", List.of("f_229463_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/StrongholdPieces$PortalRoom", List.of("f_229627_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/StrongholdPieces$StartPiece", List.of("f_229797_:Lnet/minecraft/world/level/levelgen/structure/structures/StrongholdPieces$PieceWeight;", "f_229798_:Lnet/minecraft/world/level/levelgen/structure/structures/StrongholdPieces$PortalRoom;"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/ScatteredFeaturePiece", List.of("f_72790_:I"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/SwampHutPiece", List.of("f_229949_:Z", "f_229950_:Z"));
        makeVolatileFields.put("net/minecraft/world/level/levelgen/structure/structures/WoodlandMansionPieces$PlacementData", List.of("f_230138_:Lnet/minecraft/world/level/block/Rotation;", "f_230139_:Lnet/minecraft/core/BlockPos;", "f_230140_:Ljava/lang/String;"));
        makeVolatileFieldsMapped = makeVolatileFields.entrySet().stream().map(entry -> {
            String mappedClassName = ASMUtils.mappingResolver.mapClassName("intermediary", ((String)entry.getKey()).replace('/', '.')).replace('.', '/');
            List<String> mappedFieldNames = ((List)entry.getValue()).stream().map(fieldName -> {
                String[] split = fieldName.split(":");
                return ASMUtils.mappingResolver.mapFieldName("intermediary", ((String)entry.getKey()).replace('/', '.'), split[0], split[1]) + ":" + ASMUtils.remapFieldDescriptor((String)split[1]);
            }).toList();
            return new KeyValue<String, List<String>>(mappedClassName, mappedFieldNames);
        }).collect(Collectors.toMap(KeyValue::key, KeyValue::value));
    }

    private record KeyValue<K, V>(K key, V value) {
    }
}

