/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

final class RecipeIndicator {
    static final int RENDER_SIZE = 10;
    private static final int TEXTURE_SIZE = 16;
    private static final ResourceLocation TEXTURE = Utils.getRL("textures/ingot.png");

    private RecipeIndicator() {
    }

    static void renderIndicator(GuiGraphics guiGraphics, int pX, int pY, int size) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)pX, (float)pY, 0.0f);
        float scale = (float)size / 16.0f;
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280163_(TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.m_85849_();
    }

    static List<Component> constructTooltip(ClientRecipeTracker.ClientRecipeLink link) {
        MutableComponent unified = Component.m_237115_((String)Utils.prefix("unified")).m_130946_(": ").m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        unified.m_7220_((Component)Component.m_237115_((String)Utils.prefix(link.isUnified() ? "yes" : "no")).m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));
        MutableComponent duplicate = Component.m_237115_((String)Utils.prefix("duplicate")).m_130946_(": ").m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        duplicate.m_7220_((Component)Component.m_237115_((String)Utils.prefix(link.isDuplicate() ? "yes" : "no")).m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));
        return List.of(Component.m_237115_((String)Utils.prefix("description")).m_130938_(c -> c.m_131140_(ChatFormatting.GOLD)), Component.m_237113_((String)" "), unified, duplicate, Component.m_237113_((String)" "), Component.m_237115_((String)Utils.prefix("warning")).m_130938_(c -> c.m_131140_(ChatFormatting.RED)));
    }

    static void renderTooltip(GuiGraphics guiGraphics, ClientRecipeTracker.ClientRecipeLink link, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Screen screen = mc.f_91080_;
        if (screen == null) {
            return;
        }
        List tooltip = RecipeIndicator.constructTooltip(link).stream().map(c -> font.m_92923_((FormattedText)c, screen.f_96543_ - (int)mouseX - 200)).flatMap(Collection::stream).toList();
        guiGraphics.m_280245_(font, tooltip, (int)mouseX, (int)mouseY);
    }
}

