/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterjungletemples.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterjungletemples.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockReplaceProcessor
extends StructureProcessor {
    public static final Codec<BlockReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockStateRandomizer.CODEC.fieldOf("output").forGetter(config -> config.output), (App)Codec.BOOL.optionalFieldOf("randomize_facing", (Object)false).forGetter(config -> config.randomizeFacing), (App)Codec.BOOL.optionalFieldOf("randomize_half", (Object)false).forGetter(config -> config.randomizeHalf), (App)Codec.BOOL.optionalFieldOf("copy_input_properties", (Object)false).forGetter(config -> config.copyInputProperties), (App)Codec.BOOL.optionalFieldOf("preserve_waterlog", (Object)false).forGetter(config -> config.preserveWaterlog)).apply((Applicative)instance, instance.stable(BlockReplaceProcessor::new)));
    public final BlockState targetBlock;
    public final BlockStateRandomizer output;
    public final boolean randomizeFacing;
    public final boolean randomizeHalf;
    public final boolean copyInputProperties;
    public final boolean preserveWaterlog;

    private BlockReplaceProcessor(BlockState targetBlock, BlockStateRandomizer output, boolean randomizeFacing, boolean randomizeHalf, boolean copyInputProperties, boolean preserveWaterlog) {
        this.targetBlock = targetBlock;
        this.output = output;
        this.randomizeFacing = randomizeFacing;
        this.randomizeHalf = randomizeHalf;
        this.copyInputProperties = copyInputProperties;
        this.preserveWaterlog = preserveWaterlog;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_().m_60713_(this.targetBlock.m_60734_())) {
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
            BlockState outputState = this.output.get(random);
            if (this.copyInputProperties) {
                if (blockInfoGlobal.f_74676_().m_61138_((Property)StairBlock.f_56841_) && outputState.m_61138_((Property)StairBlock.f_56841_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)blockInfoGlobal.f_74676_().m_61143_((Property)StairBlock.f_56841_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)StairBlock.f_56842_) && outputState.m_61138_((Property)StairBlock.f_56842_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)blockInfoGlobal.f_74676_().m_61143_((Property)StairBlock.f_56842_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)StairBlock.f_56843_) && outputState.m_61138_((Property)StairBlock.f_56843_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)blockInfoGlobal.f_74676_().m_61143_((Property)StairBlock.f_56843_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)SlabBlock.f_56353_) && outputState.m_61138_((Property)SlabBlock.f_56353_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)blockInfoGlobal.f_74676_().m_61143_((Property)SlabBlock.f_56353_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)WallBlock.f_57951_) && outputState.m_61138_((Property)WallBlock.f_57951_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)WallBlock.f_57951_, (Comparable)((WallSide)blockInfoGlobal.f_74676_().m_61143_((Property)WallBlock.f_57951_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)WallBlock.f_57950_) && outputState.m_61138_((Property)WallBlock.f_57950_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)WallBlock.f_57950_, (Comparable)((WallSide)blockInfoGlobal.f_74676_().m_61143_((Property)WallBlock.f_57950_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)WallBlock.f_57952_) && outputState.m_61138_((Property)WallBlock.f_57952_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)WallBlock.f_57952_, (Comparable)((WallSide)blockInfoGlobal.f_74676_().m_61143_((Property)WallBlock.f_57952_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)WallBlock.f_57953_) && outputState.m_61138_((Property)WallBlock.f_57953_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)WallBlock.f_57953_, (Comparable)((WallSide)blockInfoGlobal.f_74676_().m_61143_((Property)WallBlock.f_57953_)));
                }
                if (blockInfoGlobal.f_74676_().m_61138_((Property)WallBlock.f_57949_) && outputState.m_61138_((Property)WallBlock.f_57949_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)WallBlock.f_57949_, (Comparable)((Boolean)blockInfoGlobal.f_74676_().m_61143_((Property)WallBlock.f_57949_)));
                }
            }
            if (this.randomizeFacing) {
                if (outputState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
                }
                if (outputState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.m_235672_((RandomSource)random));
                }
            }
            if (this.randomizeHalf) {
                if (outputState.m_61138_((Property)BlockStateProperties.f_61402_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(random.m_188499_() ? Half.TOP : Half.BOTTOM));
                }
                if (outputState.m_61138_((Property)BlockStateProperties.f_61401_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)(random.m_188499_() ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
                }
                if (outputState.m_61138_((Property)BlockStateProperties.f_61397_)) {
                    outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(random.m_188499_() ? SlabType.TOP : SlabType.BOTTOM));
                }
            }
            if (levelReader instanceof WorldGenRegion) {
                WorldGenRegion worldGenRegion = (WorldGenRegion)levelReader;
                if (outputState.m_60713_(Blocks.f_49990_) || outputState.m_60713_(Blocks.f_49991_)) {
                    FlowingFluid fluid = outputState.m_60713_(Blocks.f_49990_) ? Fluids.f_76193_ : Fluids.f_76195_;
                    worldGenRegion.m_186469_(blockInfoGlobal.f_74675_(), (Fluid)fluid, 0);
                }
            }
            if (this.preserveWaterlog && outputState.m_61138_((Property)BlockStateProperties.f_61362_) && blockInfoGlobal.f_74676_().m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockInfoGlobal.f_74676_().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                outputState = (BlockState)outputState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), outputState, blockInfoGlobal.f_74677_());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.BLOCK_REPLACE_PROCESSOR;
    }
}

