/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SuspiciousMushroomEvents {
    private static final String TAG_REGEN_UNTIL = "ua_sm_regen_until";
    private static final String TAG_NEXT_PULSE = "ua_sm_next_pulse";
    private static final String TAG_COOLDOWN = "ua_sm_cd_until";
    private static final int PULSE_INTERVAL = 40;
    private static final int DURATION = 201;
    private static final int COOLDOWN = 198;

    private static boolean hasMushroom(LivingEntity e) {
        return CuriosApi.getCuriosInventory((LivingEntity)e).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SUSPICIOUS_MUSHROOM.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onLivingHurt(LivingHurtEvent e) {
        if (e.getEntity().m_9236_().f_46443_) {
            return;
        }
        DamageSource src = e.getSource();
        Entity direct = src.m_7640_();
        Entity trueSrc = src.m_7639_();
        LivingEntity attacker = null;
        if (trueSrc instanceof LivingEntity) {
            LivingEntity le;
            attacker = le = (LivingEntity)trueSrc;
        } else if (direct instanceof LivingEntity) {
            LivingEntity le2 = (LivingEntity)direct;
            attacker = le2;
        }
        if (attacker == null || !attacker.m_6084_() || attacker.m_5833_()) {
            return;
        }
        if (!SuspiciousMushroomEvents.hasMushroom(attacker)) {
            return;
        }
        boolean hasNegative = false;
        for (MobEffectInstance inst : attacker.m_21220_()) {
            if (inst == null || inst.m_19544_().m_19486_()) continue;
            hasNegative = true;
            break;
        }
        if (!hasNegative) {
            return;
        }
        double bonus = 0.15;
        if (bonus <= 0.0) {
            return;
        }
        float base = e.getAmount();
        e.setAmount((float)((double)base * (1.0 + bonus)));
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added e) {
        CompoundTag pd;
        long cdUntil;
        LivingEntity le = e.getEntity();
        if (le.m_9236_().f_46443_) {
            return;
        }
        Level level = le.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!le.m_6084_() || le.m_5833_()) {
            return;
        }
        if (!SuspiciousMushroomEvents.hasMushroom(le)) {
            return;
        }
        MobEffectInstance inst = e.getEffectInstance();
        if (inst == null || inst.m_19544_().m_19486_()) {
            return;
        }
        long now = sl.m_46467_();
        if (now < (cdUntil = (pd = le.getPersistentData()).m_128454_(TAG_COOLDOWN))) {
            return;
        }
        long regenUntil = pd.m_128454_(TAG_REGEN_UNTIL);
        if (now < regenUntil) {
            return;
        }
        pd.m_128356_(TAG_REGEN_UNTIL, now + 201L);
        pd.m_128356_(TAG_NEXT_PULSE, now + 40L);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent e) {
        LivingEntity le = e.getEntity();
        if (le.m_9236_().f_46443_) {
            return;
        }
        Level level = le.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!le.m_6084_() || le.m_5833_()) {
            return;
        }
        CompoundTag pd = le.getPersistentData();
        long now = sl.m_46467_();
        long regenUntil = pd.m_128454_(TAG_REGEN_UNTIL);
        if (now <= 0L || now >= regenUntil) {
            if (regenUntil > 0L && now >= regenUntil) {
                pd.m_128356_(TAG_COOLDOWN, now + 198L);
                pd.m_128473_(TAG_REGEN_UNTIL);
                pd.m_128473_(TAG_NEXT_PULSE);
            }
            return;
        }
        if (!SuspiciousMushroomEvents.hasMushroom(le)) {
            pd.m_128473_(TAG_REGEN_UNTIL);
            pd.m_128473_(TAG_NEXT_PULSE);
            pd.m_128356_(TAG_COOLDOWN, now + 198L);
            return;
        }
        long next = pd.m_128454_(TAG_NEXT_PULSE);
        if (now >= next) {
            le.m_5634_(1.0f);
            long nextPulse = now + 40L;
            pd.m_128356_(TAG_NEXT_PULSE, nextPulse);
        }
    }
}

