/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.network;

import java.util.function.Supplier;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class DashC2S {
    private final Dir dir;
    private static final String TAG_LAST_DASH_TICK = "ua_tabi_last_dash";
    private static final int COOLDOWN_TICKS = 30;
    private static final double STRENGTH = 1.7;

    public DashC2S(Dir d) {
        this.dir = d;
    }

    public static void encode(DashC2S m, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)m.dir);
    }

    public static DashC2S decode(FriendlyByteBuf buf) {
        return new DashC2S((Dir)buf.m_130066_(Dir.class));
    }

    public static void handle(DashC2S m, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            long last;
            ServerPlayer p = ctx.getSender();
            if (p == null) {
                return;
            }
            boolean hasMaster = CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.MASTER_NINJA_TABI.get())).isEmpty()).orElse(false);
            if (hasMaster) {
                return;
            }
            boolean hasTabi = CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.TABI.get())).isEmpty()).orElse(false);
            if (!hasTabi) {
                return;
            }
            if (p.m_36324_().m_38702_() < 7) {
                return;
            }
            if (!p.m_20096_() || p.m_5833_() || p.m_21255_() || p.m_20159_() || p.m_20072_() || p.m_20077_()) {
                return;
            }
            ServerLevel sl = (ServerLevel)p.m_9236_();
            long now = sl.m_46467_();
            if (now - (last = p.getPersistentData().m_128454_(TAG_LAST_DASH_TICK)) < 30L) {
                return;
            }
            Vec3 look = p.m_20252_(1.0f);
            Vec3 fwd = new Vec3(look.f_82479_, 0.0, look.f_82481_);
            if (fwd.m_82556_() < 1.0E-4) {
                fwd = new Vec3(0.0, 0.0, 1.0);
            }
            fwd = fwd.m_82541_();
            Vec3 left = new Vec3(fwd.f_82481_, 0.0, -fwd.f_82479_);
            Vec3 dir = switch (m.dir) {
                case Dir.BACK -> fwd.m_82490_(-1.0);
                case Dir.LEFT -> left;
                case Dir.RIGHT -> left.m_82490_(-1.0);
                default -> fwd;
            };
            Vec3 cur = p.m_20184_();
            Vec3 add = dir.m_82490_(1.7);
            double yBoost = Math.max(0.1, cur.f_82480_);
            p.m_20334_(cur.f_82479_ + add.f_82479_, yBoost, cur.f_82481_ + add.f_82481_);
            p.f_19812_ = true;
            p.f_19864_ = true;
            p.f_19789_ = 0.0f;
            sl.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 1.3f);
            sl.m_8767_((ParticleOptions)ParticleTypes.f_123796_, p.m_20185_(), p.m_20186_() + 0.1, p.m_20189_(), 12, 0.35, 0.05, 0.35, 0.02);
            if (!p.m_7500_()) {
                p.m_36399_(1.0f);
            }
            p.getPersistentData().m_128356_(TAG_LAST_DASH_TICK, now);
        });
        ctx.setPacketHandled(true);
    }

    public static enum Dir {
        FORWARD,
        LEFT,
        BACK,
        RIGHT;

    }
}

