/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.ItemHandlerHelper;

public class AccessoryBoxItem
extends Item {
    private static final ResourceLocation TABLE_ID = new ResourceLocation("uniqueaccessories", "accessory_box");
    private static final TagKey<Item> TAG_RARE = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("uniqueaccessories", "accessory_box_rare"));
    private static final TagKey<Item> TAG_EPIC = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("uniqueaccessories", "accessory_box_epic"));
    public static final String TAG_FROM_BOX = "ua_from_box";
    public static final String TAG_FROM_BOX_EXPIRES = "ua_from_box_expires";
    public static final int FROM_BOX_LIFETIME_TICKS = 20;

    public AccessoryBoxItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.accessory_box.desc1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.accessory_box.desc2").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.accessory_box.desc3").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.accessory_box.desc4").m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        LootParams params;
        ItemStack held = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)held);
        }
        ServerLevel sl = (ServerLevel)level;
        LootTable table = sl.m_7654_().m_278653_().m_278676_(TABLE_ID);
        ObjectArrayList results = table.m_287195_(params = new LootParams.Builder(sl).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287239_(player.m_36336_()).m_287235_(LootContextParamSets.f_81416_));
        if (results.isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11749_, SoundSource.PLAYERS, 0.6f, 1.1f);
        long now = sl.m_46467_();
        for (ItemStack raw : results) {
            boolean added;
            ItemStack reward = raw.m_41777_();
            AccessoryBoxItem.markFromBox(reward, now);
            if (reward.m_204117_(TAG_EPIC)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (reward.m_204117_(TAG_RARE)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.9f, 1.2f);
            }
            if (added = player.m_36356_(reward)) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)reward, (int)player.m_150109_().f_35977_);
        }
        if (!player.m_150110_().f_35937_) {
            held.m_41774_(1);
        }
        ItemStack nowInHand = player.m_21120_(hand);
        return InteractionResultHolder.m_19092_((Object)nowInHand, (boolean)level.f_46443_);
    }

    private static void markFromBox(ItemStack stack, long serverGameTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_FROM_BOX, true);
        tag.m_128356_(TAG_FROM_BOX_EXPIRES, serverGameTime + 20L);
    }
}

