/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessbiomes.procedures;

import javax.annotation.Nullable;
import net.mcreator.endlessbiomes.init.EndlessbiomesModParticleTypes;
import net.mcreator.endlessbiomes.procedures.GetVoidRiseChanceProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VoidGustRisesProcedure {
    static final float windAmplitude = 0.3f;
    static final float windFrequency = 0.02f;
    static final float yAxisModifier = 10.0f;
    static final float yFreqModifier = 0.2f;
    static final float threshold = 0.7f;
    static final double noWindRange = 30.0;
    static final double maxWindRange = 50.0;
    static final int detectionsPerBlock = 3;
    static final double gustSpeed = 0.002;
    static final double lower = 60.0;
    static final double upper = 100.0;
    public static SimplexNoise generatorX = new SimplexNoise((RandomSource)new LegacyRandomSource(474L));
    public static SimplexNoise generatorY = new SimplexNoise((RandomSource)new LegacyRandomSource(302L));
    public static SimplexNoise generatorZ = new SimplexNoise((RandomSource)new LegacyRandomSource(709L));
    public static SimplexNoise generatorS = new SimplexNoise((RandomSource)new LegacyRandomSource(697L));

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        VoidGustRisesProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        VoidGustRisesProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || entity.m_9236_().m_46472_() != Level.f_46430_) {
            return;
        }
        double riseChance = GetVoidRiseChanceProcedure.execute(world);
        y += 0.5 * (double)entity.m_20206_();
        double range = 0.0;
        double thisX = 0.0;
        double thisY = 0.0;
        double thisZ = 0.0;
        if (new Object(){

            public boolean checkGamemode(Entity _ent) {
                if (_ent instanceof ServerPlayer) {
                    ServerPlayer _serverPlayer = (ServerPlayer)_ent;
                    return _serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL;
                }
                if (_ent.m_9236_().m_5776_() && _ent instanceof Player) {
                    Player _player = (Player)_ent;
                    return Minecraft.m_91087_().m_91403_().m_104949_(_player.m_36316_().getId()) != null && Minecraft.m_91087_().m_91403_().m_104949_(_player.m_36316_().getId()).m_105325_() == GameType.SURVIVAL;
                }
                return true;
            }
        }.checkGamemode(entity)) {
            Vec3 wind = VoidGustRisesProcedure.getWind(world, x, y, z, riseChance);
            entity.m_5997_(wind.f_82479_, wind.f_82480_, wind.f_82481_);
        }
        if (entity instanceof ServerPlayer || entity instanceof Player) {
            range = 80.0;
            for (int index0 = 0; index0 < 320; ++index0) {
                double directionX = Math.random() * 2.0 - 1.0;
                double directionY = Math.random() * 2.0 - 1.0;
                double directionZ = Math.random() * 2.0 - 1.0;
                double length = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
                double distance = range * Math.pow(Math.random(), 0.6);
                thisX = x + (directionX /= length) * distance;
                Vec3 wind = VoidGustRisesProcedure.getWind(world, thisX, thisY = y + (directionY /= length) * distance, thisZ = z + (directionZ /= length) * distance, riseChance);
                if (wind.m_82553_() < 0.06000000238418579) continue;
                world.m_7106_((ParticleOptions)((SimpleParticleType)EndlessbiomesModParticleTypes.VOID_RISE.get()), thisX, thisY, thisZ, wind.f_82479_, wind.f_82480_, wind.f_82481_);
            }
        }
    }

    public static Vec3 getWind(LevelAccessor world, double x, double y, double z, double riseChance) {
        long time = world.m_6106_().m_6793_();
        double wx = generatorX.m_75467_(x * (double)0.02f, y * (double)0.02f, z * (double)0.02f);
        double wy = 10.0 * (generatorY.m_75467_(x * (double)0.02f, y * (double)0.02f, z * (double)0.02f) + 1.0) * 0.5;
        double wz = generatorZ.m_75467_(x * (double)0.02f, y * (double)0.02f, z * (double)0.02f);
        double rawStrength = (generatorS.m_75467_(x * (double)0.02f, (y + (double)time * 0.002) * (double)0.02f * (double)0.2f, z * (double)0.02f) + 1.0) * 0.5;
        double windStrength = riseChance * Math.max(rawStrength - (double)0.7f, 0.0) / (double)0.3f;
        double trailOff = 1.0;
        if (y > 60.0 && y <= 100.0) {
            trailOff = 1.0 - (y - 60.0) / 40.0;
        } else if (y > 100.0) {
            trailOff = 0.0;
        }
        double scaleFactor = (double)0.3f * windStrength * windStrength * trailOff;
        Vec3 wind = new Vec3(wx, wy, wz).m_82541_().m_82490_(scaleFactor);
        Vec3 direction = wind.m_82541_().m_82548_();
        double distance = 0.0;
        double cx = x;
        double cy = y;
        double cz = z;
        double combDist = 0.3333333333333333;
        int i = 0;
        while ((double)i < 150.0 && world.m_46859_(BlockPos.m_274561_((double)Math.floor(cx), (double)Math.floor(cy), (double)Math.floor(cz)))) {
            distance += combDist;
            cx += combDist * direction.f_82479_;
            cy += combDist * direction.f_82480_;
            cz += combDist * direction.f_82481_;
            ++i;
        }
        if (distance < 30.0) {
            wind = Vec3.f_82478_;
        } else if (distance < 50.0) {
            wind.m_82490_((distance - 30.0) / 20.0);
        }
        return wind;
    }
}

