/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.events;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.entity.Apparition;
import blueduck.blighted_beasts.entity.Bloater;
import blueduck.blighted_beasts.entity.Reaper;
import blueduck.blighted_beasts.registry.BlightEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blighted_beasts")
public class ForgeEvents {
    @SubscribeEvent
    public static void entityHurtEvent(LivingHurtEvent event) {
        if (event.getSource().m_7640_() instanceof Reaper) {
            event.getSource().m_7640_().m_5496_(SoundEvents.f_11745_, 0.4f, -1.0f);
            for (int i = 0; i < 2; ++i) {
                event.getEntity().m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, event.getEntity().m_20208_(0.5), event.getEntity().m_20187_() - 0.25, event.getEntity().m_20262_(0.5), (event.getEntity().m_217043_().m_188500_() - 0.5) * 0.5, -event.getEntity().m_217043_().m_188500_() * 0.25 + 0.1, (event.getEntity().m_217043_().m_188500_() - 0.5) * 0.5);
            }
        }
    }

    @SubscribeEvent
    public static void entityDieEvent(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Bloater)) {
            if (Config.bloatersActAsCatalysts) {
                AABB aabb = new AABB(event.getEntity().m_20097_()).m_82400_(3.0);
                List nearbyEntities = event.getEntity().m_9236_().m_45976_(Bloater.class, aabb);
                for (Bloater bloater : nearbyEntities) {
                    Bloater.placeFeature(bloater.m_20194_().m_129880_(bloater.m_9236_().m_46472_()), Holder.m_205709_((Object)((ConfiguredFeature)bloater.m_9236_().m_9598_().m_175515_(Registries.f_256911_).m_7745_(new ResourceLocation("blighted_beasts", "sculk_patch_bloater_catalyst")))), bloater.m_20183_());
                }
            }
            if (Config.apparitionCatalystSpawnChance > 0.0 && ForgeEvents.nearSculkCatalyst(event.getEntity().m_9236_(), (Entity)event.getEntity()) && event.getEntity().m_217043_().m_188500_() < Config.apparitionCatalystSpawnChance) {
                Apparition apparition = (Apparition)((EntityType)BlightEntities.SCULK_APPARITION.get()).m_20615_(event.getEntity().m_9236_());
                apparition.m_7678_(event.getEntity().m_20185_(), event.getEntity().m_20186_() - 2.25, event.getEntity().m_20189_(), event.getEntity().m_146908_(), event.getEntity().m_146909_());
                ((ServerLevel)event.getEntity().m_9236_()).m_47205_((Entity)apparition);
                for (int i = 0; i < 60; ++i) {
                    event.getEntity().m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, event.getEntity().m_20208_(0.5), event.getEntity().m_20187_() - 0.25, event.getEntity().m_20262_(0.5), (event.getEntity().m_9236_().f_46441_.m_188500_() - 0.5) * 0.5, -event.getEntity().m_9236_().f_46441_.m_188500_() * 0.25 + 0.1, (event.getEntity().m_9236_().f_46441_.m_188500_() - 0.5) * 0.5);
                }
            }
        }
    }

    @SubscribeEvent
    public static void entityTickEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().m_5776_() && ModList.get().isLoaded("sculksickness") && event.player.m_21023_((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation("sculksickness:sculk_sickness")))) {
            int amplifier = -1;
            for (MobEffectInstance effect : event.player.m_21220_()) {
                if (!effect.m_19544_().equals(BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation("sculksickness:sculk_sickness")))) continue;
                amplifier = effect.m_19564_();
                break;
            }
            if (event.player.m_217043_().m_188500_() < Config.apparitionSicknessSpawnChance * (double)(amplifier + 1)) {
                int xOffset = event.player.m_217043_().m_216332_(10, 32) * (event.player.m_217043_().m_188499_() ? -1 : 1);
                int zOffset = event.player.m_217043_().m_216332_(10, 32) * (event.player.m_217043_().m_188499_() ? -1 : 1);
                int yOffset = event.player.m_217043_().m_216332_(-8, 8);
                Apparition apparition = (Apparition)((EntityType)BlightEntities.SCULK_APPARITION.get()).m_20615_(event.player.m_9236_());
                apparition.m_7678_(event.player.m_20185_() + (double)xOffset, event.player.m_20186_() + (double)yOffset, event.player.m_20189_() + (double)zOffset, event.player.m_146908_(), event.player.m_146909_());
                ((ServerLevel)event.player.m_9236_()).m_47205_((Entity)apparition);
            }
        }
    }

    public static boolean nearSculkCatalyst(Level level, Entity entity) {
        BlockPos position = entity.m_20183_();
        for (int i = -7; i < 8; ++i) {
            for (int j = -4; j < 5; ++j) {
                for (int k = -7; k < 8; ++k) {
                    if (!level.m_8055_(position.m_7918_(i, j, k)).m_60713_(Blocks.f_220857_)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

