/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Skitter
extends Monster
implements VibrationSystem {
    public BlockPos disturbanceLocation = null;
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    private final VibrationSystem.User vibrationUser;
    private final VibrationSystem.Data vibrationData;

    public Skitter(EntityType<? extends Monster> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.f_21364_ = 10;
        this.m_21573_().m_7008_(false);
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@javax.annotation.Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.m_9236_() == p_219386_.m_9236_() && EntitySelector.f_20406_.test(p_219386_) && !this.m_7307_(p_219386_) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_())) {
                return livingentity instanceof Player || Config.skittersAttackAllMobs && !(livingentity instanceof Monster);
            }
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)BlightSounds.SKITTER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)BlightSounds.SKITTER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)BlightSounds.SKITTER_HURT.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
            this.m_5496_((SoundEvent)BlightSounds.SKITTER_WALK.get(), 1.0f, 0.75f);
        } else {
            this.m_5496_((SoundEvent)BlightSounds.SKITTER_RUN.get(), 0.625f, 0.6f);
        }
    }

    public static boolean canSpawn(EntityType<Skitter> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Skitter.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.3f;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)level2, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        super.m_8119_();
        int i = 60;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
        if (this.m_6113_() > 0.0f) {
            if (this.m_5448_() == null && !this.walkAnimationState.m_216984_()) {
                if (this.runAnimationState.m_216984_()) {
                    this.runAnimationState.m_216973_();
                }
                this.walkAnimationState.m_216977_(this.f_19797_);
            } else if (!this.runAnimationState.m_216984_()) {
                if (this.walkAnimationState.m_216984_()) {
                    this.walkAnimationState.m_216973_();
                }
                this.runAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            this.walkAnimationState.m_216973_();
            this.runAnimationState.m_216973_();
        }
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            consumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SkitterMeleeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new GoToDisturbanceGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_213854_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.85);
    }

    public float getStepHeight() {
        return 1.25f;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    public void setDisturbanceLocation(BlockPos disturbanceLocation) {
        this.disturbanceLocation = disturbanceLocation;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Skitter.this, Skitter.this.m_20192_());
        }

        public int m_280351_() {
            return 40;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            if (event.equals(GameEvent.f_157785_)) {
                return false;
            }
            if (!Skitter.this.m_21224_() && level.m_6857_().m_61937_(pos) && !Skitter.this.m_213877_() && Skitter.this.m_9236_() == level) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return Skitter.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, Entity pEntity, Entity pPlayerEntity, float pDistance) {
            if (Skitter.this.m_21224_()) {
                return;
            }
            if (pEntity != null && Skitter.this.canTargetEntity(pEntity)) {
                if (!(pEntity instanceof Monster)) {
                    if (Skitter.this.m_5448_() == null || Skitter.this.m_5448_() != null && Skitter.this.m_217043_().m_188500_() <= 0.225) {
                        Skitter.this.m_6710_((LivingEntity)pEntity);
                    }
                    if (pEntity instanceof Player) {
                        Skitter.this.m_6710_((LivingEntity)pEntity);
                    }
                }
                return;
            }
            if (Skitter.this.m_5448_() != null && Skitter.this.m_217043_().m_188500_() <= 0.225) {
                Skitter.this.m_6710_(null);
            }
            Skitter.this.disturbanceLocation = pPos;
        }
    }

    class SkitterMeleeAttackGoal
    extends MeleeAttackGoal {
        public SkitterMeleeAttackGoal() {
            super((PathfinderMob)Skitter.this, 1.7, true);
        }

        protected double m_6639_(LivingEntity p_33377_) {
            float f = Skitter.this.m_20205_() - 0.1f;
            return f * 1.25f * f * 1.25f;
        }
    }

    public class GoToDisturbanceGoal
    extends Goal {
        private final Skitter entity;

        public GoToDisturbanceGoal(Skitter entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.entity.getDisturbanceLocation() != null && !this.entity.m_21573_().m_26572_()) {
                Path path = this.entity.m_21573_().m_7864_(this.entity.getDisturbanceLocation(), 0);
                this.entity.m_21573_().m_26536_(path, 1.0);
            }
            if (this.entity.getDisturbanceLocation() != null && this.entity.m_21573_().m_26571_()) {
                this.entity.setDisturbanceLocation(null);
            }
        }

        public void m_8056_() {
        }
    }
}

