/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class Seer
extends EnderMan {
    public Seer(EntityType<? extends EnderMan> p_32485_, Level p_32486_) {
        super(p_32485_, p_32486_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SeerFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EnderMan.EndermanLookForPlayerGoal((EnderMan)this, arg_0 -> ((Seer)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_28879_ -> Config.canSeerDetectPlayers && p_28879_.m_20270_((Entity)this) < 12.0f));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder m_32541_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    boolean m_32534_(Player p_32535_) {
        ItemStack itemstack = (ItemStack)p_32535_.m_150109_().f_35975_.get(3);
        if (ForgeHooks.shouldSuppressEnderManAnger((EnderMan)this, (Player)p_32535_, (ItemStack)itemstack)) {
            return false;
        }
        Vec3 vec3 = p_32535_.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p_32535_.m_20185_(), this.m_20188_() - p_32535_.m_20188_(), this.m_20189_() - p_32535_.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? p_32535_.m_142582_((Entity)this) : false;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.1f;
    }

    public static boolean canSpawn(EntityType<Seer> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Seer.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_ && this.m_9236_().m_213780_().m_188500_() < 0.05) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 0.5, -this.f_19796_.m_188500_() * 0.25 + 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.5);
            }
        }
        super.m_8107_();
    }

    protected SoundEvent m_7515_() {
        return this.m_32531_() ? (SoundEvent)BlightSounds.SEER_AGGRO.get() : (SoundEvent)BlightSounds.SEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32527_) {
        return (SoundEvent)BlightSounds.SEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)BlightSounds.SEER_DEATH.get();
    }

    static class SeerFreezeWhenLookedAt
    extends Goal {
        private final Seer enderman;
        @Nullable
        private LivingEntity target;

        public SeerFreezeWhenLookedAt(Seer p_32550_) {
            this.enderman = p_32550_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.m_32534_((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
            this.enderman.m_5496_((SoundEvent)BlightSounds.SEER_SHRIEK.get(), 2.5f, 1.0f);
            AABB aabb = new AABB(this.enderman.m_20097_()).m_82400_(48.0);
            List nearbyEntities = this.enderman.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : nearbyEntities) {
                if (entity == null || entity.m_21224_() || !(entity instanceof Monster) || !Config.canSeerAttackNonSculk && !(entity instanceof VibrationSystem) || this.target == null || this.target.m_21224_()) continue;
                ((Monster)entity).m_6710_(this.target);
            }
        }

        public void m_8037_() {
            this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }
}

