/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.entity.projectile.ReverbProjectile;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Reverb
extends Monster
implements VibrationSystem,
RangedAttackMob {
    public BlockPos disturbanceLocation = null;
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    private final VibrationSystem.User vibrationUser;
    private final VibrationSystem.Data vibrationData;

    public Reverb(EntityType<? extends Monster> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@javax.annotation.Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.m_9236_() == p_219386_.m_9236_() && EntitySelector.f_20406_.test(p_219386_) && !this.m_7307_(p_219386_) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_())) {
                return !(livingentity instanceof Monster);
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)BlightSounds.REVERB_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)BlightSounds.REVERB_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)BlightSounds.REVERB_HURT.get();
    }

    public static boolean canSpawn(EntityType<Reverb> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Reverb.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.3f;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)level2, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        super.m_8119_();
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            consumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(8, (Goal)new GoToDisturbanceGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_213854_() {
        return true;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)((float)Config.reverbSpeed)).m_22268_(Attributes.f_22281_, (double)Config.reverbDamage).m_22268_(Attributes.f_22276_, (double)Config.reverbHealth).m_22268_(Attributes.f_22284_, 2.0);
    }

    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    public void m_6504_(LivingEntity p_32141_, float p_32142_) {
        ReverbProjectile abstractarrow = new ReverbProjectile(p_32141_.m_9236_(), (LivingEntity)this);
        double d0 = p_32141_.m_20185_() - this.m_20185_();
        double d1 = p_32141_.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = p_32141_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 0.4f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_((SoundEvent)BlightSounds.REVERB_SHOOT.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_6710_(null);
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    public void setDisturbanceLocation(BlockPos disturbanceLocation) {
        this.disturbanceLocation = disturbanceLocation;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Reverb.this, Reverb.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            if (event.equals(GameEvent.f_157785_)) {
                return false;
            }
            if (!Reverb.this.m_21224_() && level.m_6857_().m_61937_(pos) && !Reverb.this.m_213877_() && Reverb.this.m_9236_() == level) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return Reverb.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, Entity pEntity, Entity pPlayerEntity, float pDistance) {
            if (Reverb.this.m_21224_()) {
                return;
            }
            Reverb.this.m_5496_((SoundEvent)BlightSounds.REVERB_CLICK.get(), 2.0f, 1.0f);
            if (pEntity != null && Reverb.this.canTargetEntity(pEntity)) {
                if (!(pEntity instanceof Monster)) {
                    Reverb.this.m_6710_((LivingEntity)pEntity);
                    if (pEntity instanceof Player) {
                        Reverb.this.m_6710_((LivingEntity)pEntity);
                    }
                }
                return;
            }
            if (Reverb.this.m_5448_() != null) {
                Reverb.this.m_6710_(null);
            }
            Reverb.this.disturbanceLocation = pPos;
        }
    }

    public class GoToDisturbanceGoal
    extends Goal {
        private final Reverb entity;

        public GoToDisturbanceGoal(Reverb entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.entity.getDisturbanceLocation() != null && !this.entity.m_21573_().m_26572_()) {
                Path path = this.entity.m_21573_().m_7864_(this.entity.getDisturbanceLocation(), 0);
                this.entity.m_21573_().m_26536_(path, 1.0);
            }
            if (this.entity.getDisturbanceLocation() != null && this.entity.m_21573_().m_26571_()) {
                this.entity.setDisturbanceLocation(null);
            }
        }

        public void m_8056_() {
        }
    }
}

