/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.entity.goal.BloaterSwellGoal;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Contract;

public class Bloater
extends Monster
implements VibrationSystem {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Creeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(Creeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(Creeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    public int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    public BlockPos disturbanceLocation = null;
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private final VibrationSystem.Data vibrationData = new VibrationSystem.Data();

    public Bloater(EntityType<? extends Bloater> p_32278_, Level p_32279_) {
        super(p_32278_, p_32279_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BloaterSwellGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new GoToDisturbanceGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.m_9236_() == p_219386_.m_9236_() && EntitySelector.f_20406_.test(p_219386_) && !this.m_7307_(p_219386_) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_())) {
                return livingentity instanceof Player || Config.bloatersAttackAllMobs && !(livingentity instanceof Monster);
            }
        }
        return false;
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell += (int)(p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
    }

    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
    }

    public void m_8119_() {
        Level level;
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)level2, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        super.m_8119_();
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            consumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected SoundEvent m_7975_(DamageSource p_32309_) {
        return (SoundEvent)BlightSounds.BLOATER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)BlightSounds.BLOATER_DEATH.get();
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            Bloater.placeFeature(this.m_20194_().m_129880_(this.m_9236_().m_46472_()), Holder.m_205709_((Object)((ConfiguredFeature)this.m_9236_().m_9598_().m_175515_(Registries.f_256911_).m_7745_(new ResourceLocation("blighted_beasts", "sculk_patch_bloater")))), this.m_20183_());
            for (int i = 0; i < 64; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_() + this.f_19796_.m_188500_() * 0.2 - 0.1, this.m_20186_() + this.f_19796_.m_188500_() * 0.2 - 0.1, this.m_20189_() + this.f_19796_.m_188500_() * 0.2 - 0.1, this.f_19796_.m_188583_(), this.f_19796_.m_188500_() * 0.1 - 0.05, this.f_19796_.m_188583_());
            }
            this.m_146870_();
            AABB aabb = new AABB(this.m_20097_()).m_82400_(2.0);
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity2 : nearbyEntities) {
                if (entity2 == null || entity2.m_21224_()) continue;
                entity2.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)this), 12.0f);
            }
        }
    }

    public static void placeFeature(ServerLevel serverLevel, Holder<ConfiguredFeature<?, ?>> holder, BlockPos blockPos) {
        ConfiguredFeature configuredFeature = (ConfiguredFeature)holder.m_203334_();
        configuredFeature.m_224953_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), serverLevel.m_213780_(), blockPos);
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public static boolean canSpawn(EntityType<Bloater> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Bloater.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public void setDisturbanceLocation(BlockPos disturbanceLocation) {
        this.disturbanceLocation = disturbanceLocation;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Bloater.this, Bloater.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            if (event.equals(GameEvent.f_157785_)) {
                return false;
            }
            if (!Bloater.this.m_21224_() && level.m_6857_().m_61937_(pos) && !Bloater.this.m_213877_() && Bloater.this.m_9236_() == level) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return Bloater.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, Entity pEntity, Entity pPlayerEntity, float pDistance) {
            if (Bloater.this.m_21224_()) {
                return;
            }
            Bloater.this.m_5496_((SoundEvent)BlightSounds.BLOATER_CLICK.get(), 2.0f, 1.0f);
            if (pEntity != null && Bloater.this.canTargetEntity(pEntity)) {
                if (!(pEntity instanceof Monster)) {
                    Bloater.this.m_6710_((LivingEntity)pEntity);
                    if (pEntity instanceof Player) {
                        Bloater.this.m_6710_((LivingEntity)pEntity);
                    }
                }
                return;
            }
            if (Bloater.this.m_5448_() != null) {
                Bloater.this.m_6710_(null);
            }
            Bloater.this.disturbanceLocation = pPos;
        }
    }

    public class GoToDisturbanceGoal
    extends Goal {
        private final Bloater entity;

        public GoToDisturbanceGoal(Bloater entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.entity.getDisturbanceLocation() != null && !this.entity.m_21573_().m_26572_()) {
                Path path = this.entity.m_21573_().m_7864_(this.entity.getDisturbanceLocation(), 0);
                this.entity.m_21573_().m_26536_(path, 1.0);
            }
            if (this.entity.getDisturbanceLocation() != null && this.entity.m_21573_().m_26571_()) {
                this.entity.setDisturbanceLocation(null);
            }
        }

        public void m_8056_() {
        }
    }
}

