/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.entity.goal.BreakBlockGoal;
import blueduck.blighted_beasts.entity.goal.UnstickGoal;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Behemoth
extends Monster
implements GeoEntity,
VibrationSystem {
    private final VibrationSystem.User vibrationUser = new VibrationSystem.User(){
        private static final int LISTENER_RANGE = 12;
        private final EntityPositionSource positionSource;
        {
            this.positionSource = new EntityPositionSource((Entity)Behemoth.this, Behemoth.this.m_20192_());
        }

        public int m_280351_() {
            return 12;
        }

        public EntityPositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent gameEvent, GameEvent.Context context) {
            if (gameEvent.equals(GameEvent.f_157785_)) {
                return false;
            }
            if (Behemoth.this.m_21224_() || Behemoth.this.m_213877_() || !level.m_6857_().m_61937_(pos)) {
                return false;
            }
            if (Behemoth.this.m_217043_().m_188500_() < 0.2) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return Behemoth.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent gameEvent, @Nullable Entity sourceEntity, @Nullable Entity projectileOwner, float distance) {
            if (Behemoth.this.m_21224_()) {
                return;
            }
            if (sourceEntity != null && Behemoth.this.canTargetEntity(sourceEntity)) {
                if (!(sourceEntity instanceof Monster)) {
                    Behemoth.this.m_6710_((LivingEntity)sourceEntity);
                    if (sourceEntity instanceof Player) {
                        Behemoth.this.m_6710_((LivingEntity)sourceEntity);
                    }
                    Behemoth.this.isTargeting = true;
                }
                return;
            }
            if (Behemoth.this.m_5448_() != null) {
                Behemoth.this.m_6710_(null);
            }
            Behemoth.this.disturbanceLocation = pos;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }
    };
    private final VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public BlockPos disturbanceLocation = null;
    public int sniffTimer;
    public int animState = 0;
    public int animCounter = -1;
    public int xCounter = 0;
    public double oldX = 0.0;
    public double oldZ = 0.0;
    public double newX = 0.0;
    public double newZ = 0.0;
    public boolean isTargeting = false;

    public Behemoth(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        this.sniffTimer = 200;
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21530_();
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (this.m_9236_() == entity.m_9236_() && EntitySelector.f_20406_.test(entity) && !this.m_7307_(entity) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_())) {
                return !(livingentity instanceof Monster);
            }
        }
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
            this.m_5496_((SoundEvent)BlightSounds.BEHEMOTH_WALK.get(), 2.0f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)BlightSounds.BEHEMOTH_RUN.get(), 2.0f, 1.0f);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)BlightSounds.BEHEMOTH_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)BlightSounds.BEHEMOTH_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)BlightSounds.BEHEMOTH_HURT.get();
    }

    public static boolean canSpawn(EntityType<Behemoth> entityType, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return Behemoth.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        ++this.xCounter;
        if (this.xCounter >= 4) {
            this.xCounter = 0;
            this.oldX = this.newX;
            this.newX = this.f_19854_;
            this.oldZ = this.newZ;
            this.newZ = this.f_19856_;
        }
        if (this.animCounter > -1) {
            ++this.animCounter;
        }
        if (this.animCounter >= 50) {
            this.animCounter = -1;
        }
        if (this.sniffTimer > 0) {
            --this.sniffTimer;
        }
        if (this.m_21224_()) {
            return;
        }
        if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
            this.isTargeting = false;
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)serverLevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        this.isTargeting = target != null;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public double getXZSpeed() {
        return (this.newX - this.oldX) * (this.newX - this.oldX) + (this.newZ - this.oldZ) * (this.newZ - this.oldZ);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    private PlayState predicate(AnimationState<Behemoth> state) {
        if (state.isMoving() && (this.getXZSpeed() > 0.325 || this.isTargeting && (this.m_5448_() != null || !this.m_5448_().m_21224_()))) {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.run"));
            return PlayState.CONTINUE;
        }
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.walk"));
            return PlayState.CONTINUE;
        }
        if (this.animCounter == -1) {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState attackPredicate(AnimationState<Behemoth> state) {
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BehemothMeleeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new GoToDisturbanceGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GorillaSniffGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreakBlockGoal(this, difficulty -> true));
        this.f_21345_.m_25352_(2, (Goal)new UnstickGoal(this, difficulty -> true));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_213854_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22283_, 5.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8107_() {
        this.updateSwingTimeTurret();
        super.m_8107_();
    }

    protected void updateSwingTimeTurret() {
        int i = 100;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }

    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    public void setDisturbanceLocation(BlockPos disturbanceLocation) {
        this.disturbanceLocation = disturbanceLocation;
    }

    class BehemothMeleeAttackGoal
    extends MeleeAttackGoal {
        public BehemothMeleeAttackGoal() {
            super((PathfinderMob)Behemoth.this, 2.0, true);
        }

        protected double m_6639_(LivingEntity p_33377_) {
            float f = Behemoth.this.m_20205_() - 0.1f;
            return f * 1.25f * f * 1.25f;
        }
    }

    public class GoToDisturbanceGoal
    extends Goal {
        private final Behemoth entity;

        public GoToDisturbanceGoal(Behemoth entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.entity.getDisturbanceLocation() != null && !this.entity.m_21573_().m_26572_()) {
                Path path = this.entity.m_21573_().m_7864_(this.entity.getDisturbanceLocation(), 0);
                this.entity.m_21573_().m_26536_(path, 1.0);
            }
            if (this.entity.getDisturbanceLocation() != null && this.entity.m_21573_().m_26571_()) {
                this.entity.setDisturbanceLocation(null);
            }
        }

        public void m_8056_() {
        }
    }

    public class GorillaSniffGoal
    extends Goal {
        private final Behemoth entity;

        public GorillaSniffGoal(Behemoth entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            return this.entity.sniffTimer <= 0 && (this.entity.m_5448_() == null || this.entity.m_5448_().m_21224_() || !this.entity.isTargeting);
        }

        public void m_8056_() {
            Behemoth.this.sniffTimer = this.entity.m_217043_().m_188503_(600) + 200;
            this.entity.m_5496_((SoundEvent)BlightSounds.BEHEMOTH_SNIFF.get(), 1.75f, 1.0f);
            this.entity.animState = 0;
            this.entity.animCounter = 0;
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
            AABB aabb = new AABB(this.entity.m_20097_()).m_82400_(32.0);
            List nearbyEntities = this.entity.m_9236_().m_45976_(LivingEntity.class, aabb);
            ArrayList<LivingEntity> entitiesToTarget = new ArrayList<LivingEntity>();
            for (LivingEntity entity2 : nearbyEntities) {
                if (entity2 == null || entity2.m_21224_() || !this.entity.canTargetEntity((Entity)entity2)) continue;
                entitiesToTarget.add(entity2);
            }
            if (!entitiesToTarget.isEmpty()) {
                int closest = 0;
                for (int i = 1; i < entitiesToTarget.size(); ++i) {
                    if (!(((LivingEntity)entitiesToTarget.get(i)).m_20270_((Entity)this.entity) < ((LivingEntity)entitiesToTarget.get(closest)).m_20270_((Entity)this.entity))) continue;
                    closest = i;
                }
                if ((this.entity.m_217043_().m_188500_() * 8.0 + 8.0) / (double)((LivingEntity)entitiesToTarget.get(closest)).m_20270_((Entity)this.entity) < 1.0) {
                    if (this.entity.m_217043_().m_188500_() < 0.325) {
                        this.entity.m_6710_((LivingEntity)entitiesToTarget.get(closest));
                    } else {
                        this.entity.setDisturbanceLocation(((LivingEntity)entitiesToTarget.get(closest)).m_20183_());
                    }
                }
            }
        }
    }
}

