/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.entity;

import blueduck.blighted_beasts.Config;
import blueduck.blighted_beasts.registry.BlightSounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Beckon
extends AbstractGolem
implements GeoEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Beckon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int timer;
    public int screamTime = 240;
    public int healTime;

    public Beckon(EntityType<? extends AbstractGolem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.getPersistentData().m_128379_("PersistenceRequired", true);
        this.timer = this.screamTime;
        this.healTime = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
    }

    public void m_7378_(CompoundTag p_21815_) {
        super.m_7378_(p_21815_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0025f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.36f);
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        return super.m_6071_(p_30412_, p_30413_);
    }

    public void m_8107_() {
        this.updateSwingTimeTurret();
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.screamTime;
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_5496_((SoundEvent)BlightSounds.BECKON_SHRIEK.get(), 1.75f, 1.0f);
            this.m_9236_().m_220407_(GameEvent.f_223706_, this.m_20183_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(this.m_20183_())));
            this.m_9236_().m_220407_(GameEvent.f_223709_, this.m_20183_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(this.m_20183_())));
            AABB aabb = new AABB(this.m_20097_()).m_82400_((double)Config.beckonRange);
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : nearbyEntities) {
                if (entity == null || entity.m_21224_() || !(entity instanceof Monster) || Config.beckonDistractsSculkOnly && !(entity instanceof VibrationSystem) || this.m_21224_()) continue;
                ((Monster)entity).m_6710_((LivingEntity)this);
            }
        }
        --this.healTime;
        if (this.healTime <= 0 && this.m_21223_() < this.m_21233_()) {
            this.healTime = 200;
            this.m_5634_(0.05f);
        }
        super.m_8107_();
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    private PlayState predicate(AnimationState<Beckon> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.walk"));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.model.idle"));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<Beckon> state) {
        if (this.f_20911_ && this.f_20913_ != -1) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.scream"));
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void updateSwingTimeTurret() {
        int i = 100;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }
}

