/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.client.model;

import blueduck.blighted_beasts.entity.Skitter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;

public class SkitterModel<T extends Skitter>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("blighted_beasts", "skitter"), "main");
    public final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();

    public SkitterModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leg0 = this.root.m_171324_("leg0");
        this.leg1 = this.root.m_171324_("leg1");
        this.leg2 = this.root.m_171324_("leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)2.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(46, 28).m_171488_(-11.0f, -13.0f, 0.0f, 0.0f, 3.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(46, 28).m_171488_(-3.0f, -13.0f, 0.0f, 0.0f, 3.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-14.0f, -10.0f, 0.0f, 14.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)0.0f, (float)-10.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-6.0f, 0.0f, -11.0f, 12.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-5.0f, -1.0f, -10.0f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)-6.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = root.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(38, 49).m_171488_(-1.0f, 0.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(50, 49).m_171488_(2.0f, 0.0f, 0.5f, 3.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-24.0f, (float)-6.0f));
        PartDefinition leg1 = root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(38, 49).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(50, 49).m_171480_().m_171488_(-5.0f, 0.0f, 0.5f, 3.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-24.0f, (float)-6.0f));
        PartDefinition leg2 = root.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(38, 49).m_171480_().m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)11.0f));
        PartDefinition cube_r2 = leg2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(50, 49).m_171488_(0.0f, -24.0f, 0.0f, 3.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)2.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Skitter entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float scale;
        this.leg0.f_104203_ = (float)Math.sin(limbSwing) * limbSwingAmount / 2.0f;
        this.leg1.f_104203_ = (float)(-Math.sin(limbSwing)) * limbSwingAmount / 2.0f;
        this.leg2.f_104203_ = (float)Math.cos(limbSwing) * limbSwingAmount / 2.0f;
        this.body.f_104201_ = (float)Math.sin((double)ageInTicks * 0.1 + 5.0) - 24.0f;
        this.body.f_233553_ = scale = (float)Math.abs(Math.sin((double)ageInTicks * 0.1 + 5.0)) * 0.01f + 1.0f;
        this.body.f_233554_ = scale;
        this.body.f_233555_ = scale;
        this.head.f_104203_ = (float)Math.cos((double)ageInTicks * 0.1) * 0.05f + 0.1745f;
        this.head.f_104202_ = entity.f_20911_ ? (float)(Math.sin((double)entity.f_20921_ * 6.28) * -6.0 - 6.0) : -6.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

