/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.client.model;

import blueduck.blighted_beasts.entity.Seer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class SeerModel<T extends Seer>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("blighted_beasts", "seer"), "main");
    private final ModelPart root;
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Head2;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    public boolean creepy;

    public SeerModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.Body = this.root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Head2 = this.Head.m_171324_("Head2");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightLeg = this.root.m_171324_("RightLeg");
        this.LeftLeg = this.root.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition Body = root.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-16.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.25f)).m_171514_(36, 0).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Head2 = Head.m_171599_("Head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-3.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-10.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = RightArm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)27.0f, (float)1.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-10.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = LeftArm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)27.0f, (float)1.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = root.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(56, 10).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-16.0f, (float)0.0f));
        PartDefinition LeftLeg = root.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(56, 10).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-16.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Seer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.f_104203_ = (float)Math.sin(limbSwing) * limbSwingAmount * 2.0f / 3.0f;
        this.RightLeg.f_104203_ = (float)(-Math.sin(limbSwing)) * limbSwingAmount * 2.0f / 3.0f;
        this.LeftArm.f_104203_ = -0.6109f + (float)Math.cos(limbSwing) * limbSwingAmount * 2.0f / 3.0f;
        this.RightArm.f_104203_ = -0.6109f + (float)(-Math.cos(limbSwing)) * limbSwingAmount * 2.0f / 3.0f;
        this.LeftArm.m_171324_((String)"cube_r2").f_104203_ = (float)Math.cos(limbSwing) * limbSwingAmount * -1.0f;
        this.RightArm.m_171324_((String)"cube_r1").f_104203_ = (float)Math.cos(limbSwing) * limbSwingAmount;
        this.Head2.f_104201_ = this.creepy ? (float)(-4.5 + Math.sin(ageInTicks / 10.0f)) : 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

