/*
 * Decompiled with CFR 0.152.
 */
package blueduck.blighted_beasts.client.model;

import blueduck.blighted_beasts.entity.Bloater;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class BloaterModel<T extends Bloater>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("blighted_beasts", "bloater"), "main");
    private final ModelPart root;
    private final ModelPart Body;
    private final ModelPart catalyst;
    private final ModelPart tentacle;
    private final ModelPart Head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public BloaterModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.Body = this.root.m_171324_("Body");
        this.catalyst = this.Body.m_171324_("catalyst");
        this.tentacle = this.Body.m_171324_("tentacle");
        this.Head = this.Body.m_171324_("Head");
        this.leg0 = this.root.m_171324_("leg0");
        this.leg1 = this.root.m_171324_("leg1");
        this.leg2 = this.root.m_171324_("leg2");
        this.leg3 = this.root.m_171324_("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = root.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition catalyst = Body.m_171599_("catalyst", CubeListBuilder.m_171558_().m_171514_(28, 46).m_171488_(-5.0f, -5.0f, 0.0f, 10.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)2.0f));
        PartDefinition tentacle = Body.m_171599_("tentacle", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -2.0f, -8.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = root.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)3.0f));
        PartDefinition leg1 = root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)3.0f));
        PartDefinition leg2 = root.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-6.0f, (float)-4.0f));
        PartDefinition leg3 = root.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-6.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Bloater entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg0.f_104203_ = (float)Math.sin(limbSwing) * limbSwingAmount;
        this.leg1.f_104203_ = (float)(-Math.sin(limbSwing)) * limbSwingAmount;
        this.leg3.f_104203_ = (float)Math.sin(limbSwing) * limbSwingAmount;
        this.leg2.f_104203_ = (float)(-Math.sin(limbSwing)) * limbSwingAmount;
        this.Body.f_104203_ = (float)((double)0.1745f - Math.sin(limbSwing) * (double)limbSwingAmount * (double)-0.1745f);
        if (entity.m_5448_() != null) {
            this.tentacle.f_104203_ = (float)(Math.cos(limbSwing) * (double)limbSwingAmount);
            this.tentacle.f_104205_ = (float)(Math.cos(limbSwing / 2.0f) * (double)limbSwingAmount);
        }
        this.catalyst.f_233553_ = 1.0f + (float)entity.swell * 0.02f;
        this.catalyst.f_233554_ = 1.0f + (float)entity.swell * 0.02f;
        this.catalyst.f_233555_ = 1.0f + (float)entity.swell * 0.02f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

