/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.client.render.item.GargoyleAxeRenderer;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleAxeItem
extends AxeItem
implements GeoItem {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");

    public GargoyleAxeItem(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GargoyleAxeRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GargoyleAxeRenderer();
                }
                return this.renderer;
            }
        });
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (!pTarget.m_9236_().f_46443_) {
            pTarget.m_147240_(1.0, pAttacker.m_20185_() - pTarget.m_20185_(), pAttacker.m_20189_() - pTarget.m_20189_());
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack itemStack = pContext.m_43722_();
        Player player = pContext.m_43723_();
        if (player.m_21205_() == itemStack || player.m_21206_() == itemStack) {
            player.m_36335_().m_41524_((Item)this, 100);
            this.performShockwaveAttack(pContext);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down2"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down3"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.gargoyle_axe"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mythsandlegends.more_info"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private void performShockwaveAttack(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)MLSounds.SHOCKWAVE.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
        List entities = level.m_45933_((Entity)player, player.m_20191_().m_82400_(3.0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(level.m_269111_().m_269333_((LivingEntity)player), 5.0f);
            ((LivingEntity)entity).m_147240_(3.0, entity.m_20185_() + player.m_20185_(), entity.m_20189_() + player.m_20189_());
        }
        if (level.f_46443_) {
            ParticleGeneratorHelper.generateShockwaveParticles(level, (LivingEntity)player, 3.0);
        }
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "predicateController", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

